/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Uid;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeUtilTests {
    @Test(expectedExceptions={ClassCastException.class})
    public void testGetStringValue() {
        String TEST_VALUE = "test value";
        Attribute attr = AttributeBuilder.build((String)"string", (Object[])new Object[]{"test value"});
        String value = AttributeUtil.getStringValue((Attribute)attr);
        Assert.assertEquals((String)value, (String)"test value");
        attr = AttributeBuilder.build((String)"stirng");
        value = AttributeUtil.getStringValue((Attribute)attr);
        Assert.assertNull((Object)value);
        attr = AttributeBuilder.build((String)"string", (Object[])new Object[]{1});
        AttributeUtil.getStringValue((Attribute)attr);
    }

    @Test
    public void testGetAsStringValue() {
        String TEST_VALUE = "test value";
        Attribute attr = AttributeBuilder.build((String)"string", (Object[])new Object[]{"test value"});
        String value = AttributeUtil.getAsStringValue((Attribute)attr);
        Assert.assertEquals((String)value, (String)"test value");
        attr = AttributeBuilder.build((String)"stirng");
        value = AttributeUtil.getStringValue((Attribute)attr);
        Assert.assertNull((Object)value);
        attr = AttributeBuilder.build((String)"string", (Object[])new Object[]{1});
        value = AttributeUtil.getAsStringValue((Attribute)attr);
        Assert.assertEquals((String)value, (String)"1");
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testGetIntegerValue() {
        Integer TEST_VALUE = 1;
        Attribute attr = AttributeBuilder.build((String)"int", (Object[])new Object[]{TEST_VALUE});
        Integer value = AttributeUtil.getIntegerValue((Attribute)attr);
        Assert.assertEquals((Object)value, (Object)TEST_VALUE);
        attr = AttributeBuilder.build((String)"int");
        value = AttributeUtil.getIntegerValue((Attribute)attr);
        Assert.assertNull((Object)value);
        attr = AttributeBuilder.build((String)"int", (Object[])new Object[]{"1"});
        value = AttributeUtil.getIntegerValue((Attribute)attr);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testGetLongValue() {
        Long TEST_VALUE = 1L;
        Attribute attr = AttributeBuilder.build((String)"long", (Object[])new Object[]{TEST_VALUE});
        Long value = AttributeUtil.getLongValue((Attribute)attr);
        Assert.assertEquals((Object)value, (Object)TEST_VALUE);
        attr = AttributeBuilder.build((String)"long");
        value = AttributeUtil.getLongValue((Attribute)attr);
        Assert.assertNull((Object)value);
        attr = AttributeBuilder.build((String)"long", (Object[])new Object[]{"1"});
        value = AttributeUtil.getLongValue((Attribute)attr);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testBigDecimalValue() {
        BigDecimal TEST_VALUE = BigDecimal.ONE;
        Attribute attr = AttributeBuilder.build((String)"big", (Object[])new Object[]{TEST_VALUE});
        BigDecimal value = AttributeUtil.getBigDecimalValue((Attribute)attr);
        Assert.assertEquals((Object)value, (Object)TEST_VALUE);
        attr = AttributeBuilder.build((String)"big");
        value = AttributeUtil.getBigDecimalValue((Attribute)attr);
        Assert.assertNull((Object)value);
        attr = AttributeBuilder.build((String)"big", (Object[])new Object[]{"1"});
        value = AttributeUtil.getBigDecimalValue((Attribute)attr);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetSingleValue() {
        Long TEST_VALUE = 1L;
        Attribute attr = AttributeBuilder.build((String)"long", (Object[])new Object[]{TEST_VALUE});
        Object value = AttributeUtil.getSingleValue((Attribute)attr);
        Assert.assertEquals((Object)value, (Object)TEST_VALUE);
        attr = AttributeBuilder.build((String)"long");
        value = AttributeUtil.getSingleValue((Attribute)attr);
        Assert.assertNull((Object)value);
        attr = AttributeBuilder.build((String)"long", Collections.emptyList());
        value = AttributeUtil.getSingleValue((Attribute)attr);
        Assert.assertNull((Object)value);
        AttributeUtil.getSingleValue((Attribute)AttributeBuilder.build((String)"bob", (Object[])new Object[]{1, 2, 3}));
    }

    @Test
    public void testToMap() {
        HashMap<String, Attribute> expected = new HashMap<String, Attribute>();
        Attribute attr = AttributeBuilder.build((String)"daf", (Object[])new Object[]{"daf"});
        expected.put(attr.getName(), attr);
        attr = AttributeBuilder.build((String)"fasdf", (Object[])new Object[]{"fadsf3"});
        expected.put(attr.getName(), attr);
        Map actual = AttributeUtil.toMap(expected.values());
        Assert.assertEquals((Map)actual, expected);
    }

    @Test
    public void testGetUidAttribute() {
        HashSet<Object> attrs = new HashSet<Object>();
        Uid expected = new Uid("1");
        attrs.add(expected);
        Attribute attr = AttributeBuilder.build((String)"bob");
        attrs.add(attr);
        Uid actual = AttributeUtil.getUidAttribute(attrs);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testGetBasicAttributes() {
        HashSet<Object> set = new HashSet<Object>();
        set.add(new Uid("1"));
        Attribute attr = AttributeBuilder.build((String)"bob");
        set.add(attr);
        Set actual = AttributeUtil.getBasicAttributes(set);
        HashSet<Attribute> expected = new HashSet<Attribute>();
        expected.add(attr);
        Assert.assertEquals((Set)actual, expected);
    }

    @Test
    public void testIsSpecial() {
        Assert.assertTrue((boolean)AttributeUtil.isSpecial((Attribute)new Uid("1")));
        Assert.assertFalse((boolean)AttributeUtil.isSpecial((Attribute)AttributeBuilder.build((String)"b")));
    }

    @Test
    public void testNamesEqual() {
        Assert.assertTrue((boolean)AttributeUtil.namesEqual((String)"givenName", (String)"givenname"));
    }

    @Test
    public void testIsMethod() {
        Assert.assertTrue((boolean)AttributeBuilder.build((String)"fad").is("Fad"));
        Assert.assertFalse((boolean)AttributeBuilder.build((String)"fadsf").is("f"));
    }

    @Test
    public void testFindMethod() {
        Attribute expected = AttributeBuilder.build((String)"FIND_ME");
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        attrs.add(AttributeBuilder.build((String)"fadsf"));
        attrs.add(AttributeBuilder.build((String)"fadsfadsf"));
        attrs.add(expected);
        Assert.assertEquals((Object)AttributeUtil.find((String)"FIND_ME", attrs), (Object)expected);
        Assert.assertTrue((AttributeUtil.find((String)"Daffff", attrs) == null ? 1 : 0) != 0);
    }

    @Test
    public void testEnableDate() {
        Date expected = new Date();
        HashSet<Attribute> set = new HashSet<Attribute>();
        set.add(AttributeBuilder.buildEnableDate((Date)expected));
        Date actual = AttributeUtil.getEnableDate(set);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
    }
}

