/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security;

import org.identityconnectors.common.security.Encryptor;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.common.security.SimpleEncryptor;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GuardedStringTests {
    @BeforeMethod
    public void setUp() {
        GuardedString.setEncryptor((Encryptor)new SimpleEncryptor());
    }

    @AfterMethod
    public void tearDown() {
        GuardedString.setEncryptor(null);
    }

    @Test
    public void testBasics() {
        GuardedString str = new GuardedString("foo".toCharArray());
        Assert.assertEquals((String)this.decryptToString(str), (String)"foo");
        str.appendChar('2');
        Assert.assertEquals((String)this.decryptToString(str), (String)"foo2");
        Assert.assertFalse((boolean)str.verifyBase64SHA1Hash(SecurityUtil.computeBase64SHA1Hash((char[])"foo".toCharArray())));
        Assert.assertTrue((boolean)str.verifyBase64SHA1Hash(SecurityUtil.computeBase64SHA1Hash((char[])"foo2".toCharArray())));
    }

    @Test
    public void testEquals() {
        GuardedString str1 = new GuardedString();
        GuardedString str2 = new GuardedString();
        Assert.assertEquals((Object)str1, (Object)str2);
        str2.appendChar('2');
        Assert.assertFalse((boolean)str1.equals((Object)str2));
        str1.appendChar('2');
        Assert.assertEquals((Object)str1, (Object)str2);
    }

    @Test
    public void testReadOnly() {
        GuardedString str = new GuardedString("foo".toCharArray());
        Assert.assertFalse((boolean)str.isReadOnly());
        str.makeReadOnly();
        Assert.assertTrue((boolean)str.isReadOnly());
        Assert.assertEquals((String)this.decryptToString(str), (String)"foo");
        try {
            str.appendChar('2');
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        str = str.copy();
        Assert.assertEquals((String)this.decryptToString(str), (String)"foo");
        str.appendChar('2');
        Assert.assertEquals((String)this.decryptToString(str), (String)"foo2");
    }

    @Test
    public void testDispose() {
        GuardedString str = new GuardedString("foo".toCharArray());
        str.dispose();
        try {
            this.decryptToString(str);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.isReadOnly();
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.appendChar('c');
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.copy();
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.verifyBase64SHA1Hash("foo");
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testUnicode() {
        for (int i = 0; i < 65535; ++i) {
            final int expected = i;
            char c = (char)i;
            GuardedString gs = new GuardedString(new char[]{c});
            gs.access(new GuardedString.Accessor(){

                public void access(char[] clearChars) {
                    char v = clearChars[0];
                    Assert.assertEquals((int)v, (int)expected);
                }
            });
        }
    }

    private String decryptToString(GuardedString string) {
        final StringBuilder buf = new StringBuilder();
        string.access(new GuardedString.Accessor(){

            public void access(char[] chars) {
                buf.append(chars);
            }
        });
        return buf.toString();
    }
}

