/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.LogSpi;
import org.identityconnectors.common.logging.StdOutLogger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LogTests {
    @Test
    public void checkIsLoggableMethods() {
        MockLogSpi spi = new MockLogSpi();
        Log log = Log.getLog(String.class, (LogSpi)spi);
        spi._isloggable = false;
        Assert.assertFalse((boolean)log.isError());
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        spi._isloggable = true;
        Assert.assertTrue((boolean)log.isError());
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        Assert.assertNull((Object)spi._methodName);
        spi._isloggable = false;
        Assert.assertFalse((boolean)log.isInfo());
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.INFO);
        spi._isloggable = true;
        Assert.assertTrue((boolean)log.isInfo());
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.INFO);
        Assert.assertNull((Object)spi._methodName);
        spi._isloggable = false;
        Assert.assertFalse((boolean)log.isOk());
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.OK);
        spi._isloggable = true;
        Assert.assertTrue((boolean)log.isOk());
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.OK);
        Assert.assertNull((Object)spi._methodName);
        spi._isloggable = false;
        Assert.assertFalse((boolean)log.isWarning());
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.WARN);
        spi._isloggable = true;
        Assert.assertTrue((boolean)log.isWarning());
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.WARN);
        for (Log.Level level : Log.Level.values()) {
            spi._isloggable = false;
            Assert.assertFalse((boolean)log.isLoggable(level));
            Assert.assertEquals((Object)spi._level, (Object)level);
            spi._isloggable = true;
            Assert.assertTrue((boolean)log.isLoggable(level));
            Assert.assertEquals((Object)spi._level, (Object)level);
            Assert.assertEquals(spi._class, String.class);
            Assert.assertNull((Object)spi._methodName);
        }
    }

    @Test
    public void checkMessageLog() {
        String METHOD = "checkMessageLog";
        String EXPECTED_MSG = "any old message will do";
        MockLogSpi spi = new MockLogSpi();
        Log log = Log.getLog(String.class, (LogSpi)spi);
        spi._message = null;
        spi._isloggable = false;
        log.error("any old message will do", new Object[0]);
        Assert.assertNull((Object)spi._message);
        Assert.assertEquals(spi._class, String.class);
        spi._isloggable = true;
        log.error("any old message will do", new Object[0]);
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        Assert.assertEquals((String)spi._message, (String)"any old message will do");
        Assert.assertEquals(spi._class, String.class);
        Assert.assertEquals((String)spi._methodName, (String)"checkMessageLog");
    }

    @Test
    public void checkFullLogMessage() {
        String EXPECTED = "some message: {0}";
        MockLogSpi spi = new MockLogSpi();
        Log log = Log.getLog(String.class, (LogSpi)spi);
        spi._isloggable = false;
        log.log(Log.Level.INFO, (Throwable)new Exception(), "some message: {0}", new Object[]{1});
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.INFO);
        Assert.assertEquals(spi._class, String.class);
        Assert.assertNull((Object)spi._message);
        Assert.assertNull((Object)spi._exception);
        Assert.assertFalse((boolean)spi._isloggable);
        spi = new MockLogSpi();
        log = Log.getLog(String.class, (LogSpi)spi);
        spi._isloggable = true;
        Exception EX = new Exception();
        log.log(Log.Level.ERROR, (Throwable)EX, "some message: {0}", new Object[]{1});
        Assert.assertEquals((String)spi._message, (String)"some message: 1");
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        Assert.assertEquals(spi._class, String.class);
        Assert.assertEquals((Object)spi._exception, (Object)EX);
        Assert.assertTrue((boolean)spi._isloggable);
        spi = new MockLogSpi();
        log = Log.getLog(String.class, (LogSpi)spi);
        spi._isloggable = true;
        String EX_MSG = "dafdslfkj";
        log.log(Log.Level.ERROR, (Throwable)new Exception("dafdslfkj"), null, new Object[0]);
        Assert.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        Assert.assertEquals(spi._class, String.class);
        Assert.assertEquals((String)spi._message, (String)"dafdslfkj");
    }

    @Test
    public void checkBasicLogging() {
        for (Log.Level level : Log.Level.values()) {
            String EXPECTED_MSG = "Message: " + level;
            MockLogSpi spi = new MockLogSpi();
            spi._isloggable = true;
            Log log = Log.getLog(String.class, (LogSpi)spi);
            if (Log.Level.ERROR.equals((Object)level)) {
                log.error(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.INFO.equals((Object)level)) {
                log.info(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.OK.equals((Object)level)) {
                log.ok(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.WARN.equals((Object)level)) {
                log.warn(EXPECTED_MSG, new Object[0]);
            }
            Assert.assertNull((Object)spi._exception);
            Assert.assertTrue((boolean)spi._isloggable);
            Assert.assertEquals((Object)spi._level, (Object)level);
            Assert.assertEquals(spi._class, String.class);
            Assert.assertEquals((String)spi._message, (String)EXPECTED_MSG);
        }
    }

    @Test
    public void checkBasicLoggingOff() {
        for (Log.Level level : Log.Level.values()) {
            String EXPECTED_MSG = "Message: " + level;
            MockLogSpi spi = new MockLogSpi();
            spi._isloggable = false;
            Log log = Log.getLog(String.class, (LogSpi)spi);
            if (Log.Level.ERROR.equals((Object)level)) {
                log.error(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.INFO.equals((Object)level)) {
                log.info(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.OK.equals((Object)level)) {
                log.ok(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.WARN.equals((Object)level)) {
                log.warn(EXPECTED_MSG, new Object[0]);
            }
            Assert.assertNull((Object)spi._message);
            Assert.assertNull((Object)spi._exception);
            Assert.assertFalse((boolean)spi._isloggable);
            Assert.assertEquals((Object)spi._level, (Object)level);
            Assert.assertEquals(spi._class, String.class);
        }
    }

    @Test
    public void checkBasicLoggingWithFormating() {
        for (Log.Level level : Log.Level.values()) {
            String FORMAT = "Message: {0}";
            String EXPECTED_MSG = "Message: " + level;
            MockLogSpi spi = new MockLogSpi();
            spi._isloggable = true;
            Log log = Log.getLog(String.class, (LogSpi)spi);
            if (Log.Level.ERROR.equals((Object)level)) {
                log.error("Message: {0}", new Object[]{level});
            } else if (Log.Level.INFO.equals((Object)level)) {
                log.info("Message: {0}", new Object[]{level});
            } else if (Log.Level.OK.equals((Object)level)) {
                log.ok("Message: {0}", new Object[]{level});
            } else if (Log.Level.WARN.equals((Object)level)) {
                log.warn("Message: {0}", new Object[]{level});
            }
            Assert.assertEquals((String)spi._message, (String)EXPECTED_MSG);
            Assert.assertNull((Object)spi._exception);
            Assert.assertTrue((boolean)spi._isloggable);
            Assert.assertEquals((Object)level, (Object)spi._level);
            Assert.assertEquals(spi._class, String.class);
        }
    }

    @Test
    public void checkBasicLoggingWithExceptionAndFormating() {
        for (Log.Level level : Log.Level.values()) {
            String FORMAT = "Message: {0}";
            String EXPECTED_MSG = "Message: " + level;
            Exception EXPECTED_EX = new Exception(level.toString());
            MockLogSpi spi = new MockLogSpi();
            spi._isloggable = true;
            Log log = Log.getLog(String.class, (LogSpi)spi);
            if (Log.Level.ERROR.equals((Object)level)) {
                log.error((Throwable)EXPECTED_EX, "Message: {0}", new Object[]{level});
            } else if (Log.Level.INFO.equals((Object)level)) {
                log.info((Throwable)EXPECTED_EX, "Message: {0}", new Object[]{level});
            } else if (Log.Level.OK.equals((Object)level)) {
                log.ok((Throwable)EXPECTED_EX, "Message: {0}", new Object[]{level});
            } else if (Log.Level.WARN.equals((Object)level)) {
                log.warn((Throwable)EXPECTED_EX, "Message: {0}", new Object[]{level});
            }
            Assert.assertEquals((String)spi._message, (String)EXPECTED_MSG);
            Assert.assertTrue((boolean)spi._isloggable);
            Assert.assertEquals((Object)level, (Object)spi._level);
            Assert.assertEquals(spi._class, String.class);
            Assert.assertEquals((Object)spi._exception, (Object)EXPECTED_EX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkSystemProperty() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            Class orig = Log.getSpiClass();
            try {
                Log.getLog(String.class);
                Assert.assertEquals((Object)Log.getSpiClass(), StdOutLogger.class);
                Log.setSpiClass(null);
                System.setProperty(Log.LOGSPI_PROP, MockLogSpi.class.getName());
                Log.getLog(String.class);
                Assert.assertEquals((Object)Log.getSpiClass(), MockLogSpi.class);
                System.setProperty(Log.LOGSPI_PROP, StdOutLogger.class.getName());
                Assert.assertEquals((Object)Log.getSpiClass(), MockLogSpi.class);
            }
            finally {
                Log.setSpiClass((Class)orig);
                System.clearProperty(Log.LOGSPI_PROP);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkGetLog() {
        Log.getLog(MockLogSpi.class);
    }

    public static class MockLogSpi
    implements LogSpi {
        public Log.Level _level = null;
        public Class<?> _class = null;
        public String _message = null;
        public String _methodName = null;
        public Throwable _exception = null;
        public boolean _isloggable = false;

        public boolean isLoggable(Class<?> clazz, Log.Level level) {
            this._class = clazz;
            this._level = level;
            return this._isloggable;
        }

        public boolean needToInferCaller(Class<?> clazz, Log.Level level) {
            return true;
        }

        public void log(Class<?> clazz, String methodName, Log.Level level, String message, Throwable ex) {
            this._class = clazz;
            this._level = level;
            this._exception = ex;
            this._message = message;
            this._methodName = methodName;
        }

        public void log(Class<?> clazz, StackTraceElement caller, Log.Level level, String message, Throwable ex) {
            this._class = clazz;
            this._level = level;
            this._exception = ex;
            this._message = message;
            this._methodName = null != caller ? caller.getMethodName() : "unknown";
        }
    }
}

