/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

public final class Base64 {
    private static char[] alphabet;
    private static byte[] codes;

    private Base64() {
    }

    public static String encode(byte[] data) {
        if (data == null) {
            return null;
        }
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    public static byte[] decode(String encdata) {
        if (encdata == null) {
            return null;
        }
        char[] data = encdata.toCharArray();
        if (data.length == 0) {
            return new byte[0];
        }
        if (data.length % 4 != 0) {
            throw new RuntimeException("Data is not Base64 encoded.");
        }
        int len = (data.length + 3) / 4 * 3;
        if (data[data.length - 1] == '=') {
            --len;
        }
        if (data[data.length - 2] == '=') {
            --len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int ix = 0; ix < data.length; ++ix) {
            byte value = codes[data[ix] & 0xFF];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) < 8) continue;
                out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                continue;
            }
            if (data[ix] == '=') continue;
            throw new RuntimeException("Data is not Base64 encoded.");
        }
        if (index != out.length) {
            throw new RuntimeException("Data length mismatch.");
        }
        return out;
    }

    static {
        int i;
        alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        codes = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64.codes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64.codes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.codes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.codes[i] = (byte)(52 + i - 48);
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }
}

