/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FilterBuilderTests {
    @Test
    public void equalsFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        bld.setUid("233");
        bld.setName(Integer.toString(233));
        Attribute attr = AttributeBuilder.build((String)"email", (Object[])new Object[]{"bob@example.com"});
        bld.addAttribute(new Attribute[]{attr});
        ConnectorObject obj = bld.build();
        Filter filter = FilterBuilder.equalTo((Attribute)attr);
        Assert.assertTrue((boolean)filter.accept(obj));
        bld.addAttribute("email", new Object[]{"something@different.com"});
        obj = bld.build();
        Assert.assertFalse((boolean)filter.accept(obj));
        bld.addAttribute("email", new Object[]{"bob@EXAMPLE.com"});
        obj = bld.build();
        Assert.assertFalse((boolean)filter.accept(obj));
        bld = new ConnectorObjectBuilder();
        bld.setUid("3234");
        bld.setName(Integer.toString(3234));
        bld.addAttribute("adflk", new Object[]{"fafkajwe"});
        Assert.assertFalse((boolean)filter.accept(bld.build()));
    }

    @Test
    public void greaterThanFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        Attribute attr = AttributeBuilder.build((String)"count", (Object[])new Object[]{3});
        Filter filter = FilterBuilder.greaterThan((Attribute)attr);
        bld.addAttribute("count", new Object[]{4});
        bld.setUid("1");
        bld.setName(Integer.toString(1));
        boolean ret = filter.accept(bld.build());
        Assert.assertTrue((boolean)ret);
        bld.addAttribute("count", new Object[]{2});
        ret = filter.accept(bld.build());
        Assert.assertFalse((boolean)ret);
    }

    @Test
    public void greaterThanEqualsToFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        Attribute attr = AttributeBuilder.build((String)"count", (Object[])new Object[]{3});
        Filter filter = FilterBuilder.greaterThanOrEqualTo((Attribute)attr);
        bld.addAttribute("count", new Object[]{4});
        bld.setUid("1");
        bld.setName(Integer.toString(1));
        boolean ret = filter.accept(bld.build());
        Assert.assertTrue((boolean)ret);
        bld.addAttribute("count", new Object[]{2});
        ret = filter.accept(bld.build());
        Assert.assertFalse((boolean)ret);
        bld.addAttribute("count", new Object[]{3});
        ret = filter.accept(bld.build());
        Assert.assertTrue((boolean)ret);
    }

    @Test
    public void lessThanFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        Attribute attr = AttributeBuilder.build((String)"count", (Object[])new Object[]{50});
        Filter filter = FilterBuilder.lessThan((Attribute)attr);
        bld.addAttribute("count", new Object[]{49});
        bld.setUid("1");
        bld.setName(Integer.toString(1));
        boolean ret = filter.accept(bld.build());
        Assert.assertTrue((boolean)ret);
        bld.addAttribute("count", new Object[]{51});
        ret = filter.accept(bld.build());
        Assert.assertFalse((boolean)ret);
    }

    @Test
    public void lessThanEqualToFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        Attribute attr = AttributeBuilder.build((String)"count", (Object[])new Object[]{50});
        Filter filter = FilterBuilder.lessThanOrEqualTo((Attribute)attr);
        bld.addAttribute("count", new Object[]{49});
        bld.setUid("1");
        bld.setName(Integer.toString(1));
        boolean ret = filter.accept(bld.build());
        Assert.assertTrue((boolean)ret);
        bld.addAttribute("count", new Object[]{51});
        ret = filter.accept(bld.build());
        Assert.assertFalse((boolean)ret);
        bld.addAttribute("count", new Object[]{50});
        ret = filter.accept(bld.build());
        Assert.assertTrue((boolean)ret);
    }

    @Test
    public void startsWithFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        Attribute attr = AttributeBuilder.build((String)"name", (Object[])new Object[]{"fred"});
        Filter filter = FilterBuilder.startsWith((Attribute)attr);
        bld.setUid("1");
        bld.setName(Integer.toString(1));
        bld.addAttribute("name", new Object[]{"fredrick"});
        Assert.assertTrue((boolean)filter.accept(bld.build()));
        bld.addAttribute("name", new Object[]{"fasdfklj"});
        Assert.assertFalse((boolean)filter.accept(bld.build()));
    }

    @Test
    public void endsWithFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        Attribute attr = AttributeBuilder.build((String)"name", (Object[])new Object[]{"rick"});
        Filter filter = FilterBuilder.endsWith((Attribute)attr);
        bld.setUid("1");
        bld.setName(Integer.toString(1));
        bld.addAttribute("name", new Object[]{"fredrick"});
        Assert.assertTrue((boolean)filter.accept(bld.build()));
        bld.addAttribute("name", new Object[]{"fakljffd"});
        Assert.assertFalse((boolean)filter.accept(bld.build()));
    }

    @Test
    public void containsFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        Attribute attr = AttributeBuilder.build((String)"name", (Object[])new Object[]{"red"});
        Filter filter = FilterBuilder.contains((Attribute)attr);
        bld.setUid("1");
        bld.setName(Integer.toString(1));
        bld.addAttribute("name", new Object[]{"fredrick"});
        Assert.assertTrue((boolean)filter.accept(bld.build()));
        bld.addAttribute("name", new Object[]{"falkjfklj"});
        Assert.assertFalse((boolean)filter.accept(bld.build()));
    }

    @Test
    public void equalsIgnoreCaseFilter() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        Attribute attr = AttributeBuilder.build((String)"name", (Object[])new Object[]{"red"});
        Filter filter = FilterBuilder.equalsIgnoreCase((Attribute)attr);
        bld.setUid("1");
        bld.setName(Integer.toString(1));
        bld.addAttribute("name", new Object[]{"ReD"});
        Assert.assertTrue((boolean)filter.accept(bld.build()));
        bld.addAttribute("name", new Object[]{"falkjfklj"});
        Assert.assertFalse((boolean)filter.accept(bld.build()));
    }

    @Test
    public void andFilter() {
        Filter filter = FilterBuilder.and((Filter)new TrueFilter(), (Filter)new TrueFilter());
        Assert.assertTrue((boolean)filter.accept(null));
        filter = FilterBuilder.and((Filter)new TrueFilter(), (Filter)new FalseFilter());
        Assert.assertFalse((boolean)filter.accept(null));
        filter = FilterBuilder.and((Filter)new FalseFilter(), (Filter)new TrueFilter());
        Assert.assertFalse((boolean)filter.accept(null));
        filter = FilterBuilder.and((Filter)new FalseFilter(), (Filter)new FalseFilter());
        Assert.assertFalse((boolean)filter.accept(null));
    }

    @Test
    public void orFilter() {
        Filter filter = FilterBuilder.or((Filter)new TrueFilter(), (Filter)new TrueFilter());
        Assert.assertTrue((boolean)filter.accept(null));
        filter = FilterBuilder.or((Filter)new TrueFilter(), (Filter)new FalseFilter());
        Assert.assertTrue((boolean)filter.accept(null));
        filter = FilterBuilder.or((Filter)new FalseFilter(), (Filter)new TrueFilter());
        Assert.assertTrue((boolean)filter.accept(null));
        filter = FilterBuilder.or((Filter)new FalseFilter(), (Filter)new FalseFilter());
        Assert.assertFalse((boolean)filter.accept(null));
    }

    @Test
    public void notFilter() {
        Filter filter = FilterBuilder.not((Filter)new TrueFilter());
        Assert.assertFalse((boolean)filter.accept(null));
        filter = FilterBuilder.not((Filter)new FalseFilter());
        Assert.assertTrue((boolean)filter.accept(null));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void illegalArgument() {
        FilterBuilder.lessThan((Attribute)null);
    }

    @Test
    public void containsAllValuesFilterTrue() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        bld.setUid("1");
        bld.setName("1");
        bld.addAttribute("a", new Object[]{"a", "b", "c"});
        Filter filter = FilterBuilder.containsAllValues((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        Assert.assertTrue((boolean)filter.accept(bld.build()));
    }

    @Test
    public void containsAllValuesFilterFalse() {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        bld.setUid("2");
        bld.setName("1");
        bld.addAttribute("a", new Object[]{"a", "b", "c"});
        Filter filter = FilterBuilder.containsAllValues((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"a"}));
        Assert.assertFalse((boolean)filter.accept(bld.build()));
        filter = FilterBuilder.containsAllValues((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"d"}));
        Assert.assertFalse((boolean)filter.accept(bld.build()));
    }

    static class FalseFilter
    implements Filter {
        FalseFilter() {
        }

        public boolean accept(ConnectorObject obj) {
            return false;
        }

        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return (R)v.visitExtendedFilter(p, (Filter)this);
        }
    }

    static class TrueFilter
    implements Filter {
        TrueFilter() {
        }

        public boolean accept(ConnectorObject obj) {
            return true;
        }

        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return (R)v.visitExtendedFilter(p, (Filter)this);
        }
    }
}

