/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.AttributeDeltaUtil;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Uid;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeDeltaUtilTests {
    @Test(expectedExceptions={ClassCastException.class})
    public void testGetStringValue() {
        String TEST_VALUE = "test value";
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"string", (Object[])new Object[]{"test value"});
        String value = AttributeDeltaUtil.getStringValue((AttributeDelta)attr);
        Assert.assertEquals((String)value, (String)"test value");
        attr = AttributeDeltaBuilder.build((String)"stirng");
        value = AttributeDeltaUtil.getStringValue((AttributeDelta)attr);
        Assert.assertNull((Object)value);
        attr = AttributeDeltaBuilder.build((String)"string", (Object[])new Object[]{1});
        AttributeDeltaUtil.getStringValue((AttributeDelta)attr);
    }

    @Test
    public void testGetAsStringValue() {
        String TEST_VALUE = "test value";
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"string", (Object[])new Object[]{"test value"});
        String value = AttributeDeltaUtil.getAsStringValue((AttributeDelta)attr);
        Assert.assertEquals((String)value, (String)"test value");
        attr = AttributeDeltaBuilder.build((String)"stirng");
        value = AttributeDeltaUtil.getStringValue((AttributeDelta)attr);
        Assert.assertNull((Object)value);
        attr = AttributeDeltaBuilder.build((String)"string", (Object[])new Object[]{1});
        value = AttributeDeltaUtil.getAsStringValue((AttributeDelta)attr);
        Assert.assertEquals((String)value, (String)"1");
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testGetIntegerValue() {
        Integer TEST_VALUE = 1;
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"int", (Object[])new Object[]{TEST_VALUE});
        Integer value = AttributeDeltaUtil.getIntegerValue((AttributeDelta)attr);
        Assert.assertEquals((Object)value, (Object)TEST_VALUE);
        attr = AttributeDeltaBuilder.build((String)"int");
        value = AttributeDeltaUtil.getIntegerValue((AttributeDelta)attr);
        Assert.assertNull((Object)value);
        attr = AttributeDeltaBuilder.build((String)"int", (Object[])new Object[]{"1"});
        AttributeDeltaUtil.getIntegerValue((AttributeDelta)attr);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testGetLongValue() {
        Long TEST_VALUE = 1L;
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"long", (Object[])new Object[]{TEST_VALUE});
        Long value = AttributeDeltaUtil.getLongValue((AttributeDelta)attr);
        Assert.assertEquals((Object)value, (Object)TEST_VALUE);
        attr = AttributeDeltaBuilder.build((String)"long");
        value = AttributeDeltaUtil.getLongValue((AttributeDelta)attr);
        Assert.assertNull((Object)value);
        attr = AttributeDeltaBuilder.build((String)"long", (Object[])new Object[]{"1"});
        AttributeDeltaUtil.getLongValue((AttributeDelta)attr);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testBigDecimalValue() {
        BigDecimal TEST_VALUE = BigDecimal.ONE;
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"big", (Object[])new Object[]{TEST_VALUE});
        BigDecimal value = AttributeDeltaUtil.getBigDecimalValue((AttributeDelta)attr);
        Assert.assertEquals((Object)value, (Object)TEST_VALUE);
        attr = AttributeDeltaBuilder.build((String)"big");
        value = AttributeDeltaUtil.getBigDecimalValue((AttributeDelta)attr);
        Assert.assertNull((Object)value);
        attr = AttributeDeltaBuilder.build((String)"big", (Object[])new Object[]{"1"});
        AttributeDeltaUtil.getBigDecimalValue((AttributeDelta)attr);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetSingleValue() {
        Long TEST_VALUE = 1L;
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"long", (Object[])new Object[]{TEST_VALUE});
        Object value = AttributeDeltaUtil.getSingleValue((AttributeDelta)attr);
        Assert.assertEquals((Object)value, (Object)TEST_VALUE);
        attr = AttributeDeltaBuilder.build((String)"long");
        value = AttributeDeltaUtil.getSingleValue((AttributeDelta)attr);
        Assert.assertNull((Object)value);
        attr = AttributeDeltaBuilder.build((String)"long", Collections.emptyList());
        value = AttributeDeltaUtil.getSingleValue((AttributeDelta)attr);
        Assert.assertNull((Object)value);
        AttributeUtil.getSingleValue((Attribute)AttributeBuilder.build((String)"bob", (Object[])new Object[]{1, 2, 3}));
    }

    @Test
    public void testToMap() {
        HashMap<String, AttributeDelta> expected = new HashMap<String, AttributeDelta>();
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"daf", (Object[])new Object[]{"daf"});
        expected.put(attr.getName(), attr);
        attr = AttributeDeltaBuilder.build((String)"fasdf", (Object[])new Object[]{"fadsf3"});
        expected.put(attr.getName(), attr);
        Map actual = AttributeDeltaUtil.toMap(expected.values());
        Assert.assertEquals((Map)actual, expected);
    }

    @Test
    public void testGetUidAttribute() {
        HashSet<AttributeDelta> attrs = new HashSet<AttributeDelta>();
        AttributeDelta expected = AttributeDeltaBuilder.build((String)Uid.NAME, (Object[])new Object[]{"1"});
        attrs.add(expected);
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"bob");
        attrs.add(attr);
        AttributeDelta actual = AttributeDeltaUtil.getUidAttributeDelta(attrs);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testGetBasicAttributes() {
        HashSet<AttributeDelta> set = new HashSet<AttributeDelta>();
        set.add(AttributeDeltaBuilder.build((String)Uid.NAME, (Object[])new Object[]{"1"}));
        AttributeDelta attr = AttributeDeltaBuilder.build((String)"bob");
        set.add(attr);
        Set actual = AttributeDeltaUtil.getBasicAttributes(set);
        HashSet<AttributeDelta> expected = new HashSet<AttributeDelta>();
        expected.add(attr);
        Assert.assertEquals((Set)actual, expected);
    }

    @Test
    public void testIsSpecial() {
        Assert.assertTrue((boolean)AttributeDeltaUtil.isSpecial((AttributeDelta)AttributeDeltaBuilder.build((String)Uid.NAME, (Object[])new Object[]{"1"})));
        Assert.assertFalse((boolean)AttributeDeltaUtil.isSpecial((AttributeDelta)AttributeDeltaBuilder.build((String)"b")));
    }

    @Test
    public void testNamesEqual() {
        Assert.assertTrue((boolean)AttributeDeltaUtil.namesEqual((String)"givenName", (String)"givenname"));
    }

    @Test
    public void testIsMethod() {
        Assert.assertTrue((boolean)AttributeDeltaBuilder.build((String)"fad").is("Fad"));
        Assert.assertFalse((boolean)AttributeDeltaBuilder.build((String)"fadsf").is("f"));
    }

    @Test
    public void testFindMethod() {
        AttributeDelta expected = AttributeDeltaBuilder.build((String)"FIND_ME");
        HashSet<AttributeDelta> attrs = new HashSet<AttributeDelta>();
        attrs.add(AttributeDeltaBuilder.build((String)"fadsf"));
        attrs.add(AttributeDeltaBuilder.build((String)"fadsfadsf"));
        attrs.add(expected);
        Assert.assertEquals((Object)AttributeDeltaUtil.find((String)"FIND_ME", attrs), (Object)expected);
        Assert.assertTrue((AttributeDeltaUtil.find((String)"Daffff", attrs) == null ? 1 : 0) != 0);
    }

    @Test
    public void testEnableDate() {
        Date expected = new Date();
        HashSet<AttributeDelta> set = new HashSet<AttributeDelta>();
        set.add(AttributeDeltaBuilder.buildEnableDate((Date)expected));
        Date actual = AttributeDeltaUtil.getEnableDate(set);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
    }
}

