/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeDeltaBuilderTests {
    @Test
    public void nullAttributeDelta() {
        AttributeDeltaBuilder bld = new AttributeDeltaBuilder();
        bld.setName("ljhgf");
        Assert.assertNull((Object)bld.build().getValuesToReplace());
        Assert.assertNull((Object)bld.build().getValuesToAdd());
        Assert.assertNull((Object)bld.build().getValuesToRemove());
        Assert.assertNull((Object)AttributeDeltaBuilder.build((String)"fadsfd").getValuesToReplace());
        Assert.assertNull((Object)AttributeDeltaBuilder.build((String)"fadsfd").getValuesToAdd());
        Assert.assertNull((Object)AttributeDeltaBuilder.build((String)"fadsfd").getValuesToRemove());
    }

    @Test
    public void buildBoolean() {
        AttributeDeltaBuilder bld = new AttributeDeltaBuilder();
        bld.setName("Taumatawha-katangihangako-auauotamateaturi-pukakapikimaun-gahoronuku-pokaiwhenu-akitanatahu");
        bld.addValueToReplace(new Object[]{true, false});
        AttributeDelta attrDelta1 = bld.build();
        AttributeDelta attrDelta2 = bld.build();
        bld.addValueToReplace(new Object[]{false});
        AttributeDelta attrDelta3 = bld.build();
        ArrayList<Boolean> expected = new ArrayList<Boolean>();
        expected.add(true);
        expected.add(false);
        Assert.assertEquals((Collection)attrDelta1.getValuesToReplace(), expected);
        this.testAttributesDelta(attrDelta1, attrDelta2, attrDelta3);
    }

    void testAttributesDelta(AttributeDelta attrDelta1, AttributeDelta attrDelta2, AttributeDelta attrDelta3) {
        Assert.assertEquals((Object)attrDelta1, (Object)attrDelta2);
        Assert.assertEquals((Object)attrDelta1, (Object)attrDelta1);
        Assert.assertNotNull((Object)attrDelta1);
        HashSet<AttributeDelta> set = new HashSet<AttributeDelta>();
        set.add(attrDelta1);
        set.add(attrDelta2);
        set.add(attrDelta3);
        Assert.assertTrue((set.size() == 2 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void uidFromBuilderInteger() {
        AttributeDeltaBuilder.build((String)Uid.NAME, (Object[])new Object[]{1});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void uidFromBuilderLong() {
        AttributeDeltaBuilder.build((String)Uid.NAME, (Object[])new Object[]{1L});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void uidFromBuilderDouble() {
        AttributeDeltaBuilder.build((String)Uid.NAME, (Object[])new Object[]{1.0});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void mapNullAttributeDelta() {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "NOK");
        AttributeDeltaBuilder.build((String)"map", (Object[])new Object[]{map});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void mapIntegerAttributeDelta() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "NOK");
        AttributeDeltaBuilder bld = new AttributeDeltaBuilder();
        bld.addValueToReplace(new Object[]{map});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void mapShortAttributeDelta() {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("string", "NOK");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("map1", map1);
        map2.put("list", Arrays.asList(1, 2, 3, new Short("5")));
        HashMap<String, HashMap<String, Object>> map3 = new HashMap<String, HashMap<String, Object>>();
        map3.put("map2", map2);
        HashMap<String, HashMap<String, HashMap<String, Object>>> map4 = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
        map4.put("map3", map3);
        AttributeDeltaBuilder.build((String)"map", (Object[])new Object[]{map4});
    }

    @Test
    public void mapAttributeDelta() {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("string", "OK");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("map1", map1);
        map2.put("list", Arrays.asList(1, 2, 3));
        HashMap<String, HashMap<String, Object>> map3 = new HashMap<String, HashMap<String, Object>>();
        map3.put("map2", map2);
        HashMap<String, HashMap<String, HashMap<String, Object>>> map4 = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
        map4.put("map3", map3);
        AttributeDeltaBuilder.build((String)"map", (Object[])new Object[]{map4});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void conflictReplaceAndAddValues() {
        AttributeDeltaBuilder attrDelta1 = new AttributeDeltaBuilder();
        attrDelta1.setName("test");
        attrDelta1.addValueToReplace(new Object[]{"jgs"});
        attrDelta1.addValueToAdd(new Object[]{"fda"});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void conflictReplaceAndRemoveValues() {
        AttributeDeltaBuilder attrDelta1 = new AttributeDeltaBuilder();
        attrDelta1.setName("test");
        attrDelta1.addValueToReplace(new Object[]{"jgs"});
        attrDelta1.addValueToRemove(new Object[]{"fda"});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void conflictAddAndReplaceValues() {
        AttributeDeltaBuilder attrDelta1 = new AttributeDeltaBuilder();
        attrDelta1.setName("test");
        attrDelta1.addValueToAdd(new Object[]{"fda"});
        attrDelta1.addValueToReplace(new Object[]{"jgs"});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void conflictRemoveAndReplaceValues() {
        AttributeDeltaBuilder attrDelta1 = new AttributeDeltaBuilder();
        attrDelta1.setName("test");
        attrDelta1.addValueToRemove(new Object[]{"fda"});
        attrDelta1.addValueToReplace(new Object[]{"jgs"});
    }

    @Test
    public void buildAttrDeltaWithRemoveAndAddValues() {
        AttributeDeltaBuilder attrDelta1 = new AttributeDeltaBuilder();
        attrDelta1.setName("test");
        attrDelta1.addValueToRemove(new Object[]{"fda"});
        attrDelta1.addValueToAdd(new Object[]{"jgs"});
    }
}

