/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CollectionUtilTests {
    @Test
    public void testNullAsEmptyList() {
        List l = CollectionUtil.nullAsEmpty((List)null);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((int)l.size(), (int)0);
        l.add(" adf");
        List t = CollectionUtil.nullAsEmpty((List)l);
        Assert.assertEquals((Collection)l, (Collection)t);
    }

    @Test
    public void testNullAsEmptyMap() {
        Map m = CollectionUtil.nullAsEmpty((Map)null);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)m.size(), (int)0);
        m.put(" adf", "fdf");
        Map t = CollectionUtil.nullAsEmpty((Map)m);
        Assert.assertEquals((Map)m, (Map)t);
    }

    @Test
    public void testNullAsEmptySet() {
        Set l = CollectionUtil.nullAsEmpty((Set)null);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((int)l.size(), (int)0);
        l.add(" adf");
        Set t = CollectionUtil.nullAsEmpty((Set)l);
        Assert.assertEquals((Set)l, (Set)t);
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)CollectionUtil.isEmpty((Collection)null));
        ArrayList<String> c = new ArrayList<String>();
        Assert.assertTrue((boolean)CollectionUtil.isEmpty(c));
        c.add("dfa");
        Assert.assertFalse((boolean)CollectionUtil.isEmpty(c));
    }

    @Test
    public void testUnique() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test");
        list.add("test");
        Collection u = CollectionUtil.unique(list);
        Assert.assertEquals((int)u.size(), (int)1);
    }

    @Test
    public void testAsList() {
        HashSet<Integer> c = new HashSet<Integer>();
        c.add(1);
        c.add(2);
        List list = CollectionUtil.newList(c);
        Assert.assertTrue((boolean)list.remove((Object)1));
        Assert.assertTrue((boolean)list.remove((Object)2));
        list.add(2);
        c = null;
        CollectionUtil.newList(c);
        list = CollectionUtil.newList((Object[])new Integer[]{1, 2});
        Assert.assertTrue((boolean)list.remove((Object)1));
        Assert.assertTrue((boolean)list.remove((Object)2));
    }

    @Test
    public void testAsSet() {
        ArrayList<Integer> c = new ArrayList<Integer>();
        c.add(1);
        c.add(2);
        Set set = CollectionUtil.newSet(c);
        Assert.assertTrue((boolean)set.contains(1));
        Assert.assertTrue((boolean)set.contains(2));
        set.add(2);
        c = null;
        CollectionUtil.newSet(c);
        set = CollectionUtil.newSet((Object[])new Integer[]{1, 2});
        Assert.assertTrue((boolean)set.contains(1));
        Assert.assertTrue((boolean)set.contains(2));
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testList() {
        HashSet<Integer> c = new HashSet<Integer>();
        c.add(1);
        c.add(2);
        List list = CollectionUtil.newReadOnlyList(c);
        Assert.assertTrue((boolean)list.remove((Object)1));
        Assert.assertTrue((boolean)list.remove((Object)2));
        c = null;
        CollectionUtil.newReadOnlyList(c);
        list = CollectionUtil.newReadOnlyList((Object[])new Integer[]{1, 2});
        Assert.assertTrue((boolean)list.contains(1));
        Assert.assertTrue((boolean)list.contains(2));
        list.add(2);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSet() {
        ArrayList<Integer> c = new ArrayList<Integer>();
        c.add(1);
        c.add(2);
        Set set = CollectionUtil.newReadOnlySet(c);
        Assert.assertTrue((boolean)set.contains(1));
        Assert.assertTrue((boolean)set.contains(2));
        c = null;
        CollectionUtil.newReadOnlySet(c);
        set = CollectionUtil.newReadOnlySet((Object[])new Integer[]{1, 2});
        Assert.assertTrue((boolean)set.contains(1));
        Assert.assertTrue((boolean)set.contains(2));
        set.add(2);
    }

    @Test
    public void testReadonlyList() {
        Object[] data = new String[]{"a", "b", "c"};
        List expected = CollectionUtil.newReadOnlyList((Object[])new String[]{"a", "b", "c"});
        List actual = CollectionUtil.newReadOnlyList((Object[])data);
        Assert.assertEquals((Collection)actual, (Collection)expected);
    }

    @Test
    public void testReadonlySet() {
        Object[] data = new String[]{"a", "b", "c"};
        Set expected = CollectionUtil.newReadOnlySet((Object[])new String[]{"a", "b", "c"});
        Set actual = CollectionUtil.newReadOnlySet((Object[])data);
        Assert.assertEquals((Set)actual, (Set)expected);
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)CollectionUtil.equals(null, null));
        Assert.assertFalse((boolean)CollectionUtil.equals(null, (Object)"str"));
        Assert.assertTrue((boolean)CollectionUtil.equals((Object)"str", (Object)"str"));
        byte[] arr1 = new byte[]{1, 2, 3};
        byte[] arr2 = new byte[]{1, 2, 3};
        byte[] arr3 = new byte[]{1, 2, 4};
        byte[] arr4 = new byte[]{1, 2};
        int[] arr5 = new int[]{1, 2, 3};
        Assert.assertTrue((boolean)CollectionUtil.equals((Object)arr1, (Object)arr2));
        Assert.assertFalse((boolean)CollectionUtil.equals((Object)arr2, (Object)arr3));
        Assert.assertFalse((boolean)CollectionUtil.equals((Object)arr2, (Object)arr4));
        Assert.assertFalse((boolean)CollectionUtil.equals((Object)arr2, (Object)arr5));
        ArrayList<byte[]> list1 = new ArrayList<byte[]>();
        ArrayList<byte[]> list2 = new ArrayList<byte[]>();
        list1.add(arr1);
        list2.add(arr2);
        Assert.assertTrue((boolean)CollectionUtil.equals(list1, list2));
        list2.add(arr2);
        Assert.assertFalse((boolean)CollectionUtil.equals(list1, list2));
        list1.add(arr1);
        Assert.assertTrue((boolean)CollectionUtil.equals(list1, list2));
        list1.add(arr1);
        list2.add(arr3);
        Assert.assertFalse((boolean)CollectionUtil.equals(list1, list2));
        HashMap<String, byte[]> map1 = new HashMap<String, byte[]>();
        HashMap<String, byte[]> map2 = new HashMap<String, byte[]>();
        map1.put("key1", arr1);
        map2.put("key1", arr2);
        Assert.assertTrue((boolean)CollectionUtil.equals(map1, map2));
        map2.put("key2", arr2);
        Assert.assertFalse((boolean)CollectionUtil.equals(map1, map2));
        map1.put("key2", arr1);
        Assert.assertTrue((boolean)CollectionUtil.equals(map1, map2));
        map1.put("key2", arr3);
        Assert.assertFalse((boolean)CollectionUtil.equals(map1, map2));
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        set1.add("val");
        set2.add("val");
        Assert.assertTrue((boolean)CollectionUtil.equals(set1, set2));
        set2.add("val2");
        Assert.assertFalse((boolean)CollectionUtil.equals(set1, set2));
        set1.add("val2");
        Assert.assertTrue((boolean)CollectionUtil.equals(set1, set2));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((int)CollectionUtil.hashCode(null), (int)0);
        Assert.assertEquals((int)CollectionUtil.hashCode((Object)"str"), (int)"str".hashCode());
        byte[] arr1 = new byte[]{1, 2, 3};
        byte[] arr2 = new byte[]{1, 2, 3};
        byte[] arr3 = new byte[]{1, 2, 4};
        byte[] arr4 = new byte[]{1, 2};
        int[] arr5 = new int[]{1, 2, 3};
        Assert.assertEquals((int)CollectionUtil.hashCode((Object)arr1), (int)CollectionUtil.hashCode((Object)arr2));
        Assert.assertFalse((CollectionUtil.hashCode((Object)arr2) == CollectionUtil.hashCode((Object)arr3) ? 1 : 0) != 0);
        Assert.assertFalse((CollectionUtil.hashCode((Object)arr2) == CollectionUtil.hashCode((Object)arr4) ? 1 : 0) != 0);
        Assert.assertTrue((CollectionUtil.hashCode((Object)arr2) == CollectionUtil.hashCode((Object)arr5) ? 1 : 0) != 0);
        ArrayList<byte[]> list1 = new ArrayList<byte[]>();
        ArrayList<byte[]> list2 = new ArrayList<byte[]>();
        list1.add(arr1);
        list2.add(arr2);
        Assert.assertTrue((CollectionUtil.hashCode(list1) == CollectionUtil.hashCode(list2) ? 1 : 0) != 0);
        list2.add(arr2);
        Assert.assertFalse((CollectionUtil.hashCode(list1) == CollectionUtil.hashCode(list2) ? 1 : 0) != 0);
        list1.add(arr1);
        Assert.assertTrue((CollectionUtil.hashCode(list1) == CollectionUtil.hashCode(list2) ? 1 : 0) != 0);
        list1.add(arr1);
        list2.add(arr3);
        Assert.assertFalse((CollectionUtil.hashCode(list1) == CollectionUtil.hashCode(list2) ? 1 : 0) != 0);
        HashMap<String, byte[]> map1 = new HashMap<String, byte[]>();
        HashMap<String, byte[]> map2 = new HashMap<String, byte[]>();
        map1.put("key1", arr1);
        map2.put("key1", arr2);
        Assert.assertTrue((CollectionUtil.hashCode(map1) == CollectionUtil.hashCode(map2) ? 1 : 0) != 0);
        map2.put("key2", arr2);
        Assert.assertFalse((CollectionUtil.hashCode(map1) == CollectionUtil.hashCode(map2) ? 1 : 0) != 0);
        map1.put("key2", arr1);
        Assert.assertTrue((CollectionUtil.hashCode(map1) == CollectionUtil.hashCode(map2) ? 1 : 0) != 0);
        map1.put("key2", arr3);
        Assert.assertFalse((CollectionUtil.hashCode(map1) == CollectionUtil.hashCode(map2) ? 1 : 0) != 0);
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        set1.add("val");
        set2.add("val");
        Assert.assertTrue((CollectionUtil.hashCode(set1) == CollectionUtil.hashCode(set2) ? 1 : 0) != 0);
        set2.add("val2");
        Assert.assertFalse((CollectionUtil.hashCode(set1) == CollectionUtil.hashCode(set2) ? 1 : 0) != 0);
        set1.add("val2");
        Assert.assertTrue((CollectionUtil.hashCode(set1) == CollectionUtil.hashCode(set2) ? 1 : 0) != 0);
    }
}

