/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.ArrayList;
import java.util.Locale;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.LocaleTestUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeTests {
    @BeforeMethod
    public void before() {
        LocaleTestUtil.resetLocaleCache();
    }

    @Test
    public void testName() {
        Attribute actual = AttributeBuilder.build((String)"bob");
        Assert.assertEquals((Object)actual, (Object)AttributeBuilder.build((String)"boB"));
        Assert.assertTrue((boolean)actual.is("BoB"));
    }

    @Test
    public void testArrays() {
        ArrayList<byte[]> values1 = new ArrayList<byte[]>();
        values1.add(new byte[]{0, 1});
        ArrayList<byte[]> values2 = new ArrayList<byte[]>();
        values2.add(new byte[]{0, 1});
        Attribute attribute1 = AttributeBuilder.build((String)"test", values1);
        Attribute attribute2 = AttributeBuilder.build((String)"test", values2);
        Assert.assertEquals((Object)attribute1, (Object)attribute2);
    }

    @Test
    public void testNormal() {
        Assert.assertEquals((Object)AttributeBuilder.build((String)"test", (Object[])new Object[]{1, 2, 4}), (Object)AttributeBuilder.build((String)"test", (Object[])new Object[]{1, 2, 4}));
        Assert.assertFalse((boolean)AttributeBuilder.build((String)"test", (Object[])new Object[]{1, 2, 4}).equals((Object)AttributeBuilder.build((String)"test", (Object[])new Object[]{2, 4})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualsObservesLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr"));
            Attribute attribute1 = AttributeBuilder.build((String)"i");
            Attribute attribute2 = AttributeBuilder.build((String)"I");
            Assert.assertFalse((boolean)attribute1.equals((Object)attribute2));
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashCodeIndependentOnLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            Attribute attribute = AttributeBuilder.build((String)"i");
            int hash1 = attribute.hashCode();
            Locale.setDefault(new Locale("tr"));
            int hash2 = attribute.hashCode();
            Assert.assertEquals((int)hash1, (int)hash2);
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }
}

