/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.fest.assertions.api.Assertions;
import org.identityconnectors.common.security.Encryptor;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.common.security.SimpleEncryptor;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GuardedByteArrayTests {
    @BeforeMethod
    public void setUp() {
        GuardedByteArray.setEncryptor((Encryptor)new SimpleEncryptor());
    }

    @AfterMethod
    public void tearDown() {
        GuardedByteArray.setEncryptor(null);
    }

    @Test
    public void testBasics() {
        GuardedByteArray bytes = new GuardedByteArray(new byte[]{0, 1, 2});
        Assertions.assertThat((byte[])this.decryptToBytes(bytes)).isEqualTo((Object)new byte[]{0, 1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2}, this.decryptToBytes(bytes)));
        bytes.appendByte((byte)3);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3}, this.decryptToBytes(bytes)));
        Assert.assertFalse((boolean)bytes.verifyBase64SHA1Hash(SecurityUtil.computeBase64SHA1Hash((byte[])new byte[]{0, 1, 2})));
        Assert.assertTrue((boolean)bytes.verifyBase64SHA1Hash(SecurityUtil.computeBase64SHA1Hash((byte[])new byte[]{0, 1, 2, 3})));
    }

    @Test
    public void testEquals() {
        GuardedByteArray bytes1 = new GuardedByteArray();
        GuardedByteArray bytes2 = new GuardedByteArray();
        Assert.assertEquals((Object)bytes1, (Object)bytes2);
        bytes2.appendByte((byte)3);
        Assert.assertFalse((boolean)bytes1.equals((Object)bytes2));
        bytes1.appendByte((byte)3);
        Assert.assertEquals((Object)bytes1, (Object)bytes2);
    }

    @Test
    public void testReadOnly() {
        GuardedByteArray bytes = new GuardedByteArray(new byte[]{0, 1, 2});
        Assert.assertFalse((boolean)bytes.isReadOnly());
        bytes.makeReadOnly();
        Assert.assertTrue((boolean)bytes.isReadOnly());
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2}, this.decryptToBytes(bytes)));
        try {
            bytes.appendByte((byte)3);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        bytes = bytes.copy();
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2}, this.decryptToBytes(bytes)));
        bytes.appendByte((byte)3);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3}, this.decryptToBytes(bytes)));
    }

    @Test
    public void testDispose() {
        GuardedByteArray str = new GuardedByteArray(new byte[]{0, 1, 2});
        str.dispose();
        try {
            this.decryptToBytes(str);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            str.isReadOnly();
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            str.appendByte((byte)3);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            str.copy();
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            str.verifyBase64SHA1Hash("foo");
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRange() {
        for (int i = -128; i < 128; ++i) {
            final byte expected = (byte)i;
            GuardedByteArray bytes = new GuardedByteArray(new byte[]{(byte)i});
            bytes.access(new GuardedByteArray.Accessor(){

                public void access(byte[] clearBytes) {
                    byte v = clearBytes[0];
                    Assert.assertEquals((byte)v, (byte)expected);
                }
            });
        }
    }

    private byte[] decryptToBytes(GuardedByteArray bytes) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        bytes.access(new GuardedByteArray.Accessor(){

            public void access(byte[] bytes) {
                out.write(bytes, 0, bytes.length);
            }
        });
        return out.toByteArray();
    }
}

