/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.identityconnectors.common.IOUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IOUtilsTests {
    @Test
    public void quietClose() {
        ExceptionReader rdr = new ExceptionReader();
        IOUtil.quietClose((Reader)rdr);
        Assert.assertTrue((boolean)rdr.closeCalled);
        ExceptionInputStream ins = new ExceptionInputStream();
        IOUtil.quietClose((InputStream)ins);
        Assert.assertTrue((boolean)ins.closeCalled);
        ExceptionOutputStream os = new ExceptionOutputStream();
        IOUtil.quietClose((OutputStream)os);
        Assert.assertTrue((boolean)os.closeCalled);
        ExceptionWriter wrt = new ExceptionWriter();
        IOUtil.quietClose((Writer)wrt);
        Assert.assertTrue((boolean)wrt.closeCalled);
    }

    @Test
    public void resourcePath() {
    }

    static class ExceptionOutputStream
    extends OutputStream {
        boolean closeCalled;

        ExceptionOutputStream() {
        }

        @Override
        public void close() throws IOException {
            this.closeCalled = true;
            throw new IOException();
        }

        @Override
        public void write(int arg0) throws IOException {
        }
    }

    static class ExceptionWriter
    extends Writer {
        boolean closeCalled;

        ExceptionWriter() {
        }

        @Override
        public void close() throws IOException {
            this.closeCalled = true;
            throw new IOException();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] arg0, int arg1, int arg2) throws IOException {
        }
    }

    static class ExceptionInputStream
    extends InputStream {
        boolean closeCalled;

        ExceptionInputStream() {
        }

        @Override
        public void close() throws IOException {
            this.closeCalled = true;
            throw new IOException();
        }

        @Override
        public int read() throws IOException {
            return 0;
        }
    }

    static class ExceptionReader
    extends Reader {
        boolean closeCalled;

        ExceptionReader() {
        }

        @Override
        public void close() throws IOException {
            this.closeCalled = true;
            throw new IOException();
        }

        @Override
        public int read(char[] arg0, int arg1, int arg2) throws IOException {
            return 0;
        }
    }
}

