/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects.filter;

import java.util.List;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;

public class ContainsAllValuesFilter
extends AttributeFilter {
    private final String name;
    private final List<Object> values;

    public ContainsAllValuesFilter(Attribute attr) {
        super(attr);
        this.name = attr.getName();
        this.values = attr.getValue();
    }

    @Override
    public boolean accept(ConnectorObject obj) {
        Attribute found = obj.getAttributeByName(this.name);
        if (found != null) {
            return found.getValue().containsAll(this.values);
        }
        return false;
    }

    @Override
    public <R, P> R accept(FilterVisitor<R, P> v, P p) {
        return v.visitContainsAllValuesFilter(p, this);
    }
}

