/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.script;

import org.identityconnectors.common.script.Script;
import org.identityconnectors.common.script.ScriptBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptTests {
    @Test
    public void testBasic() {
        Script s1 = new Script("Groovy", "print 'foo'");
        Assert.assertEquals((String)s1.getScriptLanguage(), (String)"Groovy");
        Assert.assertEquals((String)s1.getScriptText(), (String)"print 'foo'");
        Script s2 = new ScriptBuilder().setScriptLanguage("Groovy").setScriptText("print 'foo'").build();
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals((int)s1.hashCode(), (int)s2.hashCode());
    }

    @Test
    public void testLanguageNotBlank() {
        try {
            new ScriptBuilder().setScriptText("print 'foo'").build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ScriptBuilder().setScriptText("print 'foo'").setScriptLanguage("").build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ScriptBuilder().setScriptText("print 'foo'").setScriptLanguage(" ").build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTextNotNull() {
        try {
            new ScriptBuilder().setScriptLanguage("Groovy").build();
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        new ScriptBuilder().setScriptLanguage("Groovy").setScriptText("").build();
    }
}

