/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.StringPrintWriter;
import org.identityconnectors.common.StringUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StringUtilTests {
    private static final String TEMPLATE = "StringUtilTests_template.js";
    private static final String PAUSE_TEXT = "pause.text";
    private static final String RESUME_TEXT = "resume.text";
    private static final String REFRESH_TIME = "refresh.time";
    private static final String GRAPH_IDS = "graphs";
    final char TEXTQ = (char)34;
    final char FEILDD = (char)44;
    private static final String[] PROP_TEST = new String[]{"# Some comment", "prop1=SomeProp", "prop2=OtherProp"};

    @Test
    public void testIndexOfDigit() {
        int test = 0;
        String TEST0 = null;
        String TEST1 = "fsadlkjffj";
        String TEST2 = "abac2dafj";
        String TEST3 = "fa323jf4af";
        test = StringUtil.indexOfDigit(TEST0);
        Assert.assertEquals((int)test, (int)-1);
        test = StringUtil.indexOfDigit((String)"fsadlkjffj");
        Assert.assertEquals((int)test, (int)-1);
        test = StringUtil.indexOfDigit((String)"abac2dafj");
        Assert.assertEquals((int)test, (int)4);
        test = StringUtil.indexOfDigit((String)"fa323jf4af");
        Assert.assertEquals((int)test, (int)2);
    }

    @Test
    public void testIndexOfNonDigit() {
        int test = 0;
        String TEST0 = null;
        String TEST1 = "2131398750976";
        String TEST2 = "21312a9320484";
        String TEST3 = "32323aa323435";
        test = StringUtil.indexOfNonDigit(TEST0);
        Assert.assertEquals((int)test, (int)-1);
        test = StringUtil.indexOfNonDigit((String)"2131398750976");
        Assert.assertEquals((int)test, (int)-1);
        test = StringUtil.indexOfNonDigit((String)"21312a9320484");
        Assert.assertEquals((int)test, (int)5);
        test = StringUtil.indexOfNonDigit((String)"32323aa323435");
        Assert.assertEquals((int)test, (int)5);
    }

    @Test
    public void testSubDigitString() {
    }

    @Test
    public void testStripXmlAttribute() {
        String[][] DATA = new String[][]{{null, null, null}, {"attr='fads'", "attr", ""}, {"at1='fasd' at1=''", "at1", ""}};
        String tst = null;
        for (int i = 0; i < DATA.length; ++i) {
            tst = StringUtil.stripXmlAttribute((String)DATA[i][0], (String)DATA[i][1]);
            Assert.assertEquals((String)tst, (String)DATA[i][2]);
        }
    }

    @Test
    public void testStripNewlines() {
        String[][] TESTS;
        for (String[] data : TESTS = new String[][]{{null, null}, {"afdslf\n", "afdslf"}, {"afds\nfadkfj", "afdsfadkfj"}, {"afds \nfadkfj", "afds fadkfj"}, {"afds\n fadkfj", "afds fadkfj"}}) {
            String tmp = StringUtil.stripNewlines((String)data[0]);
            Assert.assertEquals((String)tmp, (String)data[1]);
        }
    }

    @Test
    public void testStripXmlComments() {
        String[][] DATA = new String[][]{{null, null}, {"<!--test1-->", ""}, {"test data", "test data"}, {"<!--test data", "<!--test data"}, {"test data-->", "test data-->"}, {"test data <!-- fasdkfj -->", "test data "}, {"<!-- fasdkfj --> test data", " test data"}, {"<!-- fasdkfj --> test data<!-- fadsom-->", " test data"}};
        String tst = null;
        for (int i = 0; i < DATA.length; ++i) {
            tst = StringUtil.stripXmlComments((String)DATA[i][0]);
            Assert.assertEquals((String)tst, (String)DATA[i][1]);
        }
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)StringUtil.isEmpty(null));
        Assert.assertTrue((boolean)StringUtil.isEmpty((String)""));
        Assert.assertFalse((boolean)StringUtil.isEmpty((String)" "));
        Assert.assertFalse((boolean)StringUtil.isEmpty((String)"bob"));
        Assert.assertFalse((boolean)StringUtil.isEmpty((String)"  bob  "));
    }

    @Test
    public void testIsBlank() {
        Assert.assertTrue((boolean)StringUtil.isBlank(null));
        Assert.assertTrue((boolean)StringUtil.isBlank((String)""));
        Assert.assertTrue((boolean)StringUtil.isBlank((String)" "));
        Assert.assertFalse((boolean)StringUtil.isBlank((String)"bob"));
        Assert.assertFalse((boolean)StringUtil.isBlank((String)"  bob  "));
    }

    @Test
    public void testIsNotEmpty() {
        Assert.assertFalse((boolean)StringUtil.isNotEmpty(null));
        Assert.assertFalse((boolean)StringUtil.isNotEmpty((String)""));
        Assert.assertTrue((boolean)StringUtil.isNotEmpty((String)" "));
        Assert.assertTrue((boolean)StringUtil.isNotEmpty((String)"bob"));
        Assert.assertTrue((boolean)StringUtil.isNotEmpty((String)"  bob  "));
    }

    @Test
    public void testIsNotBlank() {
        Assert.assertFalse((boolean)StringUtil.isNotBlank(null));
        Assert.assertFalse((boolean)StringUtil.isNotBlank((String)""));
        Assert.assertFalse((boolean)StringUtil.isNotBlank((String)" "));
        Assert.assertTrue((boolean)StringUtil.isNotBlank((String)"bob"));
        Assert.assertTrue((boolean)StringUtil.isNotBlank((String)"  bob  "));
    }

    @Test
    public void testReplaceVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(PAUSE_TEXT, "PAUSE");
        vars.put(REFRESH_TIME, "5");
        vars.put(RESUME_TEXT, "RESUME");
        vars.put(GRAPH_IDS, "1,2,4345");
        String tmpl = IOUtil.getResourceAsString(this.getClass(), (String)TEMPLATE);
        for (Map.Entry entry : vars.entrySet()) {
            String value;
            String key = (String)entry.getKey();
            Assert.assertTrue(((tmpl = StringUtil.replaceVariable((String)tmpl, (String)key, (String)(value = (String)entry.getValue()))).indexOf(value) != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWhtiespace() {
        Assert.assertTrue((boolean)StringUtil.isWhitespace((char)' '));
        Assert.assertTrue((boolean)StringUtil.isWhitespace((char)'\t'));
        Assert.assertFalse((boolean)StringUtil.isWhitespace((char)'\n'));
        Assert.assertFalse((boolean)StringUtil.isWhitespace((char)'\r'));
        for (char i = 'a'; i < 'Z'; i = (char)(i + '\u0001')) {
            Assert.assertFalse((boolean)StringUtil.isWhitespace((char)i));
        }
    }

    @Test
    public void testParseLine() {
        List values = CollectionUtil.newReadOnlyList((Object[])new Object[]{"bob", "george", 4, 23, 230948});
        StringUtilTests.parseLineTest('\"', ',', values);
    }

    @Test
    public void testRandomParseLine() {
        Random r = new Random(17L);
        char[] replace = new char[]{'\"', ','};
        for (int i = 0; i < 100; ++i) {
            List<Object> values = StringUtilTests.randomList(r, 10, replace, 'a');
            StringUtilTests.parseLineTest('\"', ',', values);
        }
    }

    static void parseLineTest(char textQ, char fieldD, List<Object> values) {
        String csv = StringUtilTests.createCSVLine(textQ, fieldD, values);
        List parsedValues = StringUtil.parseLine((String)csv, (char)fieldD, (char)textQ);
        Assert.assertEquals((Collection)parsedValues, StringUtilTests.toStringList(values));
    }

    static String createCSVLine(char textQ, char fieldD, List<Object> values) {
        StringBuilder bld = new StringBuilder();
        boolean first = true;
        for (Object o : values) {
            if (first) {
                first = false;
            } else {
                bld.append(fieldD);
            }
            if (o instanceof String) {
                bld.append(textQ);
            }
            bld.append(o);
            if (!(o instanceof String)) continue;
            bld.append(textQ);
        }
        return bld.toString();
    }

    static List<String> toStringList(List<Object> list) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Object o : list) {
            ret.add(o.toString());
        }
        return ret;
    }

    static List<Object> randomList(Random r, int size, char[] invalid, char valid) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            Object add;
            if (r.nextBoolean()) {
                add = r.nextInt();
            } else if (r.nextBoolean()) {
                add = r.nextDouble();
            } else {
                String str = StringUtil.randomString((Random)r, (int)r.nextInt(30));
                for (char c : invalid) {
                    str = str.replace(c, valid);
                }
                add = str;
            }
            ret.add(add);
        }
        return ret;
    }

    @Test
    public void testRandomString() {
        String s = StringUtil.randomString();
        Assert.assertTrue((s.length() < 257 ? 1 : 0) != 0);
    }

    @Test
    public void testEndsWith() {
        Assert.assertTrue((boolean)StringUtil.endsWith((String)"afdsf", (char)'f'));
        Assert.assertFalse((boolean)StringUtil.endsWith(null, (char)'f'));
        Assert.assertFalse((boolean)StringUtil.endsWith((String)"fadsfkj", (char)'f'));
    }

    @Test
    public void testToProperties() {
        StringPrintWriter wrt = new StringPrintWriter();
        wrt.println(PROP_TEST);
        wrt.flush();
        String inp = wrt.getString();
        Properties prop = StringUtil.toProperties((String)inp);
        Assert.assertEquals((Object)prop.get("prop1"), (Object)"SomeProp");
        Assert.assertEquals((Object)prop.get("prop2"), (Object)"OtherProp");
    }
}

