/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.identityconnectors.common.EqualsHashCodeBuilder;
import org.identityconnectors.common.StringUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EqualsHashCodeBuilderTests {
    @Test
    public void testObject() {
        TestObject o1 = new TestObject(2);
        TestObject o2 = new TestObject(2);
        TestObject o3 = new TestObject(3);
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testLong() {
        long o1 = 1L;
        long o2 = 1L;
        long o3 = 2L;
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testInt() {
        int o1 = 1;
        int o2 = 1;
        int o3 = 3;
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testShort() {
        short o1 = 1;
        short o2 = 1;
        short o3 = 3;
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testChar() {
        char o1 = 'a';
        char o2 = 'a';
        char o3 = 'c';
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)Character.valueOf(o1));
        eq2.append((Object)Character.valueOf(o2));
        eq3.append((Object)Character.valueOf(o3));
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testByte() {
        byte o1 = 1;
        byte o2 = 1;
        byte o3 = 3;
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testDouble() {
        double o1 = 1.0;
        double o2 = 1.0;
        double o3 = 2.0;
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testFloat() {
        float o1 = 1.0f;
        float o2 = 1.0f;
        float o3 = 2.0f;
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)Float.valueOf(o1));
        eq2.append((Object)Float.valueOf(o2));
        eq3.append((Object)Float.valueOf(o3));
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testBoolean() {
        boolean o1 = true;
        boolean o2 = true;
        boolean o3 = false;
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testObjectArray() {
        TestObject[] o1 = new TestObject[]{new TestObject(4), new TestObject(5), null};
        TestObject[] o2 = new TestObject[]{new TestObject(4), new TestObject(5), null};
        TestObject[] o3 = new TestObject[]{new TestObject(5), new TestObject(5), null};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testLongArray() {
        long[] o1 = new long[]{5L, 6L};
        long[] o2 = new long[]{5L, 6L};
        long[] o3 = new long[]{6L, 6L};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testIntArray() {
        int[] o1 = new int[]{5, 6};
        int[] o2 = new int[]{5, 6};
        int[] o3 = new int[]{6, 6};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testShortArray() {
        short[] o1 = new short[]{5, 6};
        short[] o2 = new short[]{5, 6};
        short[] o3 = new short[]{6, 6};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testCharArray() {
        char[] o1 = new char[]{'\u0005', '\u0006'};
        char[] o2 = new char[]{'\u0005', '\u0006'};
        char[] o3 = new char[]{'\u0006', '\u0006'};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testByteArray() {
        byte[] o1 = new byte[]{5, 6};
        byte[] o2 = new byte[]{5, 6};
        byte[] o3 = new byte[]{6, 6};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testDoubleArray() {
        double[] o1 = new double[]{5.0, 6.0};
        double[] o2 = new double[]{5.0, 6.0};
        double[] o3 = new double[]{6.0, 6.0};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testFloatArray() {
        float[] o1 = new float[]{5.0f, 6.0f};
        float[] o2 = new float[]{5.0f, 6.0f};
        float[] o3 = new float[]{6.0f, 6.0f};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testBooleanArray() {
        boolean[] o1 = new boolean[]{true, false};
        boolean[] o2 = new boolean[]{true, false};
        boolean[] o3 = new boolean[]{false, false};
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)o1);
        eq2.append((Object)o2);
        eq3.append((Object)o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testObjectArrayHiddenByObject() {
        TestObject[] array1 = new TestObject[]{new TestObject(4), new TestObject(5)};
        TestObject[] array2 = new TestObject[]{new TestObject(4), new TestObject(5)};
        TestObject[] array3 = new TestObject[]{new TestObject(5), new TestObject(5)};
        TestObject[] o1 = array1;
        TestObject[] o2 = array2;
        TestObject[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testLongArrayHiddenByObject() {
        long[] array1 = new long[]{5L, 6L};
        long[] array2 = new long[]{5L, 6L};
        long[] array3 = new long[]{6L, 6L};
        long[] o1 = array1;
        long[] o2 = array2;
        long[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testIntArrayHiddenByObject() {
        int[] array1 = new int[]{5, 6};
        int[] array2 = new int[]{5, 6};
        int[] array3 = new int[]{6, 6};
        int[] o1 = array1;
        int[] o2 = array2;
        int[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testShortArrayHiddenByObject() {
        short[] array1 = new short[]{5, 6};
        short[] array2 = new short[]{5, 6};
        short[] array3 = new short[]{6, 6};
        short[] o1 = array1;
        short[] o2 = array2;
        short[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testCharArrayHiddenByObject() {
        char[] array1 = new char[]{'\u0005', '\u0006'};
        char[] array2 = new char[]{'\u0005', '\u0006'};
        char[] array3 = new char[]{'\u0006', '\u0006'};
        char[] o1 = array1;
        char[] o2 = array2;
        char[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testByteArrayHiddenByObject() {
        byte[] array1 = new byte[]{5, 6};
        byte[] array2 = new byte[]{5, 6};
        byte[] array3 = new byte[]{6, 6};
        byte[] o1 = array1;
        byte[] o2 = array2;
        byte[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testDoubleArrayHiddenByObject() {
        double[] array1 = new double[]{5.0, 6.0};
        double[] array2 = new double[]{5.0, 6.0};
        double[] array3 = new double[]{6.0, 6.0};
        double[] o1 = array1;
        double[] o2 = array2;
        double[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testFloatArrayHiddenByObject() {
        float[] array1 = new float[]{5.0f, 6.0f};
        float[] array2 = new float[]{5.0f, 6.0f};
        float[] array3 = new float[]{6.0f, 6.0f};
        float[] o1 = array1;
        float[] o2 = array2;
        float[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testBooleanArrayHiddenByObject() {
        boolean[] array1 = new boolean[]{true, false};
        boolean[] array2 = new boolean[]{true, false};
        boolean[] array3 = new boolean[]{false, false};
        boolean[] o1 = array1;
        boolean[] o2 = array2;
        boolean[] o3 = array3;
        this.xtestHiddenByObject(o1, o2, o3);
    }

    @Test
    public void testUnrelatedClasses() {
        Object[] x = new Object[]{new TestACanEqualB(1)};
        Object[] y = new Object[]{new TestBCanEqualA(1)};
        Object[] z = new Object[]{new TestBCanEqualA(2)};
        Assert.assertTrue((boolean)Arrays.equals(x, x));
        Assert.assertTrue((boolean)Arrays.equals(y, y));
        Assert.assertTrue((boolean)Arrays.equals(x, y));
        Assert.assertTrue((boolean)Arrays.equals(y, x));
        Assert.assertTrue((boolean)x[0].equals(x[0]));
        Assert.assertTrue((boolean)y[0].equals(y[0]));
        Assert.assertTrue((boolean)x[0].equals(y[0]));
        Assert.assertTrue((boolean)y[0].equals(x[0]));
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append((Object)x);
        eq2.append((Object)y);
        eq3.append((Object)z);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
    }

    @Test
    public void testList() {
        ArrayList<String> o1 = new ArrayList<String>();
        ArrayList<String> o2 = new ArrayList<String>();
        ArrayList<String> o3 = new ArrayList<String>();
        o1.add("something");
        o2.add("something");
        o3.add("somethingelse");
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append(o1);
        eq2.append(o2);
        eq3.append(o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testSet() {
        HashSet<String> o1 = new HashSet<String>();
        HashSet<String> o2 = new HashSet<String>();
        HashSet<String> o3 = new HashSet<String>();
        o1.add("something");
        o2.add("something");
        o3.add("somethingelse");
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append(o1);
        eq2.append(o2);
        eq3.append(o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testNonCollectionSupport() {
        EqualsHashCodeBuilder eq = new EqualsHashCodeBuilder();
        try {
            eq.append(Collections.unmodifiableCollection(new ArrayList()));
            Assert.fail((String)"Should fail because Collections are not supported!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void xtestHiddenByObject(Object o1, Object o2, Object o3) {
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append(o1);
        eq2.append(o2);
        eq3.append(o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    void xtestHashCode(EqualsHashCodeBuilder eq1, EqualsHashCodeBuilder eq2, EqualsHashCodeBuilder eq3) {
        HashSet<EqualsHashCodeBuilder> set = new HashSet<EqualsHashCodeBuilder>();
        set.add(eq1);
        set.add(eq2);
        set.add(eq3);
        Assert.assertTrue((set.size() == 2 ? 1 : 0) != 0);
    }

    void xtestEqualsBuilderHashCode() {
        HashMap o1 = new HashMap();
        HashMap o2 = new HashMap();
        HashMap o3 = new HashMap();
        EqualsHashCodeBuilder eq1 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq2 = new EqualsHashCodeBuilder();
        EqualsHashCodeBuilder eq3 = new EqualsHashCodeBuilder();
        eq1.append(o1);
        eq2.append(o2);
        eq3.append(o3);
        Assert.assertTrue((boolean)eq1.equals((Object)eq1));
        Assert.assertTrue((boolean)eq1.equals((Object)eq2));
        Assert.assertTrue((boolean)eq2.equals((Object)eq1));
        Assert.assertFalse((boolean)eq1.equals(null));
        Assert.assertFalse((boolean)eq1.equals((Object)eq3));
        Assert.assertFalse((boolean)eq3.equals((Object)eq1));
        this.xtestHashCode(eq1, eq2, eq3);
    }

    @Test
    public void testBeanComparison() throws Exception {
        TestBean b1 = new TestBean(new Random());
        TestBean b2 = (TestBean)b1.clone();
        TestBean b3 = new TestBean(new Random());
        EqualsHashCodeBuilder bld1 = new EqualsHashCodeBuilder();
        bld1.appendBean((Object)b1);
        EqualsHashCodeBuilder bld2 = new EqualsHashCodeBuilder();
        bld2.appendBean((Object)b2);
        Assert.assertTrue((boolean)bld1.equals((Object)bld1));
        Assert.assertTrue((boolean)bld1.equals((Object)bld2));
        EqualsHashCodeBuilder bld3 = new EqualsHashCodeBuilder();
        bld3.appendBean((Object)b3);
        Assert.assertFalse((boolean)bld2.equals((Object)bld3));
    }

    public static class TestBCanEqualA {
        private int b;

        public TestBCanEqualA(int b) {
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TestACanEqualB) {
                return this.b == ((TestACanEqualB)o).getA();
            }
            if (o instanceof TestBCanEqualA) {
                return this.b == ((TestBCanEqualA)o).getB();
            }
            return false;
        }

        public int getB() {
            return this.b;
        }
    }

    public static class TestACanEqualB {
        private int a;

        public TestACanEqualB(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TestACanEqualB) {
                return this.a == ((TestACanEqualB)o).getA();
            }
            if (o instanceof TestBCanEqualA) {
                return this.a == ((TestBCanEqualA)o).getB();
            }
            return false;
        }

        public int getA() {
            return this.a;
        }
    }

    static class TestEmptySubObject
    extends TestObject {
        public TestEmptySubObject(int a) {
            super(a);
        }
    }

    static class TestSubObject
    extends TestObject {
        private int b;

        public TestSubObject() {
            super(0);
        }

        public TestSubObject(int a, int b) {
            super(a);
            this.b = b;
        }

        @Override
        public boolean equals(Object o) {
            boolean ret = false;
            if (o instanceof TestSubObject) {
                if (o == this) {
                    ret = true;
                } else {
                    TestSubObject rhs = (TestSubObject)o;
                    ret = super.equals(o) && this.b == rhs.b;
                }
            }
            return ret;
        }

        public void setB(int b) {
            this.b = b;
        }

        public int getB() {
            return this.b;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 19 * this.b;
        }
    }

    static class TestObject {
        static final int SEED = 19;
        private int a;

        public TestObject() {
        }

        public TestObject(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            boolean ret = false;
            if (o instanceof TestObject) {
                if (o == this) {
                    ret = true;
                } else {
                    TestObject rhs = (TestObject)o;
                    ret = this.a == rhs.a;
                }
            }
            return ret;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getA() {
            return this.a;
        }

        public int hashCode() {
            return this.a * 19;
        }
    }

    public static class TestBean
    implements Cloneable {
        private String arg1;
        private int arg2;
        private long arg3;
        private double arg4;
        private byte arg5;

        public TestBean(Random r) {
            if (r != null) {
                this.arg1 = StringUtil.randomString((Random)r, (int)25);
                this.arg2 = r.nextInt();
                this.arg3 = r.nextLong();
                this.arg4 = r.nextDouble();
                this.arg5 = (byte)r.nextInt();
            }
        }

        public String getArg1() {
            return this.arg1;
        }

        public void setArg1(String arg1) {
            this.arg1 = arg1;
        }

        public int getArg2() {
            return this.arg2;
        }

        public void setArg2(int arg2) {
            this.arg2 = arg2;
        }

        public long getArg3() {
            return this.arg3;
        }

        public void setArg3(long arg3) {
            this.arg3 = arg3;
        }

        public double getArg4() {
            return this.arg4;
        }

        public void setArg4(double arg4) {
            this.arg4 = arg4;
        }

        public byte getArg5() {
            return this.arg5;
        }

        public void setArg5(byte arg5) {
            this.arg5 = arg5;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

