/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.commons.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class ExpectProxy<T>
implements InvocationHandler {
    private final List<String> methodNames = new ArrayList<String>();
    private final List<Object> retVals = new ArrayList<Object>();
    private int count = 0;

    public ExpectProxy<T> expectAndReturn(String methodName, Object retVal) {
        this.methodNames.add(methodName);
        this.retVals.add(retVal);
        return this;
    }

    public ExpectProxy<T> expect(String methodName) {
        this.methodNames.add(methodName);
        this.retVals.add(null);
        return this;
    }

    public ExpectProxy<T> expectAndThrow(String methodName, Throwable throwEx) {
        return this.expectAndReturn(methodName, throwEx);
    }

    public boolean isDone() {
        return this.count == this.methodNames.size();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ext = "";
        if (this.methodNames.size() > this.count) {
            String mname = this.methodNames.get(this.count);
            ext = " The expected call no: " + (this.count + 1) + " was " + mname + ".";
            if (method.getName().equals(mname)) {
                Object ret;
                if ((ret = this.retVals.get(this.count++)) instanceof Throwable) {
                    throw (Throwable)ret;
                }
                return ret;
            }
        }
        throw new AssertionError((Object)("The call of method :" + method + " was not expected." + (String)ext + " Please call expectAndReturn(methodName,retVal) to fix it"));
    }

    public T getProxy(Class<T> clazz) {
        ClassLoader cl = this.getClass().getClassLoader();
        Class[] intef = new Class[]{clazz};
        return (T)Proxy.newProxyInstance(cl, intef, (InvocationHandler)this);
    }
}

