/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnection;
import org.connid.bundles.csvdir.utilities.AttributeValue;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class CommonOperation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Boolean userExists(String uidString, CSVDirConnection conn, CSVDirConfiguration conf) throws SQLException {
        ResultSet resultSet = conn.allCsvFiles();
        String[] keys = conf.getKeyColumnNames();
        String[] uidKeys = uidString.split(conf.getKeyseparator());
        try {
            boolean found = false;
            while (resultSet.next() && !found) {
                boolean toBeContinued = true;
                for (int i = 0; i < keys.length && toBeContinued; ++i) {
                    String value = resultSet.getString(keys[i]);
                    if (value.equalsIgnoreCase(uidKeys[i])) continue;
                    toBeContinued = false;
                }
                found = toBeContinued;
            }
            Boolean bl = found;
            return bl;
        }
        finally {
            resultSet.close();
        }
    }

    protected static String createUid(String[] keys, ResultSet rs, String keySeparator) throws SQLException {
        StringBuilder uid = new StringBuilder();
        if (keys != null && keys.length > 0) {
            for (String field : keys) {
                if (uid.length() > 0) {
                    uid.append(keySeparator);
                }
                uid.append(rs.getString(field));
            }
        }
        return uid.toString();
    }

    protected Map<String, String> getAttributeMap(CSVDirConfiguration conf, Set<Attribute> attrs, Name name) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Boolean status = null;
        for (Attribute attr : attrs) {
            AttributeValue attrValue = new AttributeValue(attr.getValue());
            if (attr.is(Name.NAME)) {
                String[] keys = conf.getKeyColumnNames();
                if (keys.length != 1) continue;
                attributes.put(keys[0], name.getNameValue());
                continue;
            }
            if (attr.is(OperationalAttributes.ENABLE_NAME)) {
                status = attrValue.toBoolean();
                continue;
            }
            if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                attributes.put(conf.getPasswordColumnName(), attrValue.toSecureString());
                continue;
            }
            attributes.put(attr.getName(), attrValue.toString(conf.getMultivalueSeparator()));
        }
        if (StringUtil.isNotBlank((String)conf.getStatusColumn())) {
            attributes.put(conf.getStatusColumn(), status == null ? conf.getDefaultStatusValue() : (status != false ? conf.getEnabledStatusValue() : conf.getDisabledStatusValue()));
        }
        return attributes;
    }

    protected ConnectorObject buildConnectorObject(CSVDirConfiguration conf, ResultSet resultSet) throws SQLException {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
            String name = resultSet.getMetaData().getColumnName(i);
            String value = resultSet.getString(name);
            if (name.equalsIgnoreCase(conf.getPasswordColumnName()) && StringUtil.isNotBlank((String)value)) {
                bld.addAttribute(new Attribute[]{AttributeBuilder.buildPassword((char[])value.toCharArray())});
                continue;
            }
            if (name.equalsIgnoreCase(conf.getStatusColumn())) {
                boolean status = (StringUtil.isBlank((String)value) ? conf.getDefaultStatusValue() : value).equals(conf.getEnabledStatusValue());
                bld.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((boolean)status)});
                continue;
            }
            bld.addAttribute(name, new AttributeValue(value, conf.getMultivalueSeparator()).get());
        }
        Uid uid = new Uid(CommonOperation.createUid(conf.getKeyColumnNames(), resultSet, conf.getKeyseparator()));
        bld.setUid(uid);
        bld.setName(uid.getUidValue());
        return bld.build();
    }
}

