/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnection;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirExecuteQuery;
import net.tirasa.connid.bundles.csvdir.methods.CommonOperation;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;

public class CSVDirSync
extends CommonOperation {
    private static final Log LOG = Log.getLog(CSVDirExecuteQuery.class);
    private static long token = 0L;
    private final CSVDirConfiguration conf;
    private final CSVDirConnection conn;
    private final ObjectClass objectClass;
    private SyncToken syncToken;
    private final SyncResultsHandler handler;
    private final OperationOptions options;

    public CSVDirSync(CSVDirConfiguration conf, ObjectClass objectClass, SyncToken syncToken, SyncResultsHandler handler, OperationOptions options) throws ClassNotFoundException, SQLException {
        this.conf = conf;
        this.objectClass = objectClass;
        this.syncToken = syncToken;
        this.handler = handler;
        this.options = options;
        this.conn = CSVDirConnection.openConnection(conf);
    }

    public long execute() {
        try {
            long l = this.executeImpl();
            return l;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "error during updating", new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.closeConnection();
                }
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "Error closing connections", new Object[0]);
            }
        }
    }

    private long executeImpl() throws SQLException {
        if (this.objectClass == null || !this.objectClass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        if (this.handler == null) {
            throw new IllegalArgumentException("Invalid handler");
        }
        if (this.syncToken == null || this.syncToken.getValue() == null) {
            this.syncToken = new SyncToken((Object)0);
        }
        try {
            this.buildSyncDelta(this.conn.modifiedCsvFiles(Long.valueOf(this.syncToken.getValue().toString())), this.handler);
            token = this.conn.getFileSystem().getHighestTimeStamp();
        }
        catch (NumberFormatException e) {
            LOG.error((Throwable)e, "error during syncronization", new Object[0]);
            throw new ConnectorIOException((Throwable)e);
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "error during syncronization", new Object[0]);
            throw new ConnectorIOException((Throwable)e);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSyncDelta(ResultSet resultSet, SyncResultsHandler handler) throws SQLException {
        boolean handled = true;
        try {
            while (resultSet.next() && handled) {
                ConnectorObject connObject = this.buildConnectorObject(this.conf, resultSet);
                SyncDeltaBuilder syncDeltaBuilder = this.createSyncDelta(connObject);
                this.choseRightDeltaType(resultSet, syncDeltaBuilder);
                handled = handler.handle(syncDeltaBuilder.build());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private void choseRightDeltaType(ResultSet rs, SyncDeltaBuilder syncDeltaBuilder) throws SQLException {
        if (StringUtil.isNotBlank((String)this.conf.getDeleteColumnName()) && Boolean.valueOf(this.getValueFromColumnName(rs, this.conf.getDeleteColumnName())).booleanValue()) {
            syncDeltaBuilder.setDeltaType(SyncDeltaType.DELETE);
        } else {
            syncDeltaBuilder.setDeltaType(SyncDeltaType.CREATE_OR_UPDATE);
        }
    }

    private SyncDeltaBuilder createSyncDelta(ConnectorObject connObject) {
        SyncDeltaBuilder syncDeltaBuilder = new SyncDeltaBuilder();
        syncDeltaBuilder.setObject(connObject);
        syncDeltaBuilder.setUid(connObject.getUid());
        syncDeltaBuilder.setToken(this.getLatestSyncToken());
        return syncDeltaBuilder;
    }

    private String getValueFromColumnName(ResultSet rs, String columnName) throws SQLException {
        return rs.getString(rs.findColumn(columnName));
    }

    private SyncToken getLatestSyncToken() {
        return new SyncToken((Object)token);
    }
}

