/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import java.sql.SQLException;
import java.util.Set;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnection;
import net.tirasa.connid.bundles.csvdir.methods.CommonOperation;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.Uid;

public class CSVDirCreate
extends CommonOperation {
    private static final Log LOG = Log.getLog(CSVDirCreate.class);
    private final CSVDirConnection conn;
    private final CSVDirConfiguration conf;
    private final Set<Attribute> attrs;

    public CSVDirCreate(CSVDirConfiguration conf, Set<Attribute> attrs) throws SQLException, ClassNotFoundException {
        this.conf = conf;
        this.attrs = attrs;
        this.conn = CSVDirConnection.openConnection(conf);
    }

    public Uid execute() {
        try {
            Uid uid = this.executeImpl();
            return uid;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "error during creation", new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.closeConnection();
                }
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "Error closing connections", new Object[0]);
            }
        }
    }

    private Uid executeImpl() throws SQLException {
        Name name = AttributeUtil.getNameFromAttributes(this.attrs);
        if (name == null || StringUtil.isBlank((String)name.getNameValue())) {
            throw new IllegalArgumentException("No Name attribute provided in the attributes");
        }
        if (CSVDirCreate.userExists(name.getNameValue(), this.conn, this.conf).booleanValue()) {
            throw new ConnectorException("User Exists");
        }
        this.conn.insertAccount(this.getAttributeMap(this.conf, this.attrs, name));
        LOG.ok("Creation commited", new Object[0]);
        return new Uid(name.getNameValue());
    }
}

