/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.database;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.tirasa.connid.bundles.csvdir.utilities.QueryTemplate;
import net.tirasa.connid.bundles.csvdir.utilities.Utilities;
import org.identityconnectors.framework.common.objects.Uid;

public final class QueryCreator {
    private QueryCreator() {
    }

    private static String getWhereClause(Uid uid, String keySeparator, String[] keys) {
        StringBuilder where = new StringBuilder();
        String[] uidKeys = uid.getUidValue().split(keySeparator);
        for (int i = 0; i < keys.length; ++i) {
            where.append(keys[i]).append("=").append("'").append(uidKeys[i]).append("'");
            if (i >= keys.length - 1) continue;
            where.append(" AND ");
        }
        return where.toString();
    }

    private static Map<String, String> getKeyValueMap(Map<String, String> valuesMap) {
        LinkedHashMap<String, String> keyValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : valuesMap.entrySet()) {
            if (entry.getValue() == null) {
                keyValueMap.put(entry.getKey(), "NULL");
                continue;
            }
            keyValueMap.put(entry.getKey(), "'" + entry.getValue() + "'");
        }
        return keyValueMap;
    }

    public static String insertQuery(Map<String, String> valuesMap, String tableName) {
        Map<String, String> keyValueMap = QueryCreator.getKeyValueMap(valuesMap);
        QueryTemplate queryTemplate = new QueryTemplate("INSERT INTO {0}({1}) VALUES({2})");
        return queryTemplate.apply(tableName, Utilities.join(keyValueMap.keySet(), ','), Utilities.join(keyValueMap.values(), ','));
    }

    public static String updateQuery(Map<String, String> valuesMap, Uid uid, String keySeparator, String[] keys, String tableName) {
        Map<String, String> keyValueMap = QueryCreator.getKeyValueMap(valuesMap);
        ArrayList<String> set = new ArrayList<String>(keyValueMap.size());
        for (Map.Entry<String, String> entry : keyValueMap.entrySet()) {
            set.add(entry.getKey() + "=" + entry.getValue());
        }
        QueryTemplate queryTemplate = new QueryTemplate("UPDATE {0} SET {1} WHERE {2}");
        return queryTemplate.apply(tableName, Utilities.join(set, ','), QueryCreator.getWhereClause(uid, keySeparator, keys));
    }

    public static String deleteQuery(Uid uid, String keySeparator, String[] keys, String tableName) {
        QueryTemplate queryTemplate = new QueryTemplate("DELETE FROM {0} WHERE {1}");
        return queryTemplate.apply(tableName, QueryCreator.getWhereClause(uid, keySeparator, keys));
    }
}

