/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.database;

import java.io.File;
import java.io.FileFilter;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;

public class FileSystem {
    private final CSVDirConfiguration conf;
    private final File sourcePath;
    private final FileFilter fileFilter;
    private long highestTimeStamp;

    public FileSystem(CSVDirConfiguration conf) {
        this.conf = conf;
        this.sourcePath = new File(conf.getSourcePath());
        this.fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileSystem.this.isMatched(file);
            }
        };
    }

    public final File[] getAllCsvFiles() {
        File[] csvFiles = this.sourcePath.listFiles(this.fileFilter);
        return this.returnNewArrayIfCsvFilesIsEmpty(csvFiles);
    }

    public final File getLastModifiedCsvFile() {
        File[] csvFiles = this.getAllCsvFiles();
        long tm = 0L;
        File lastModifiedFile = null;
        for (File file : csvFiles) {
            if (file.lastModified() <= tm) continue;
            tm = file.lastModified();
            lastModifiedFile = file;
        }
        return lastModifiedFile;
    }

    public final File[] getModifiedCsvFiles(final long timeStamp) {
        File[] csvFiles;
        for (File file : csvFiles = this.sourcePath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileSystem.this.isMatched(file) && file.lastModified() > timeStamp;
            }
        })) {
            if (file.lastModified() <= this.highestTimeStamp) continue;
            this.highestTimeStamp = file.lastModified();
        }
        return this.returnNewArrayIfCsvFilesIsEmpty(csvFiles);
    }

    private File[] returnNewArrayIfCsvFilesIsEmpty(File[] csvFiles) {
        return csvFiles == null ? new File[]{} : csvFiles;
    }

    public final long getHighestTimeStamp() {
        return this.highestTimeStamp;
    }

    private boolean isMatched(File file) {
        return !file.isDirectory() && (file.getName().matches(this.conf.getFileMask()) || file.getName().matches("DEFAULT.*\\.csv"));
    }
}

