/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.database.FileSystem;
import net.tirasa.connid.bundles.csvdir.database.FileToDB;
import net.tirasa.connid.bundles.csvdir.database.QueryCreator;
import net.tirasa.connid.bundles.csvdir.utilities.Utilities;
import net.tirasa.connid.bundles.db.common.SQLParam;
import net.tirasa.connid.bundles.db.common.SQLUtil;
import org.hsqldb.jdbcDriver;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Uid;

public class CSVDirConnection {
    private static final Log LOG = Log.getLog(CSVDirConnection.class);
    private static final String HSQLDB_JDBC_URL_PREFIX = "jdbc:hsqldb:file:";
    private static final String HSQLDB_DB_NAME = "csvdir_db";
    private final String viewname;
    private final String query;
    private final String jdbcUrl;
    private final Set<String> tables = new HashSet<String>();
    private final Connection conn;
    private final CSVDirConfiguration conf;
    private final FileSystem fileSystem;
    private final FileToDB fileToDB;

    private CSVDirConnection(CSVDirConfiguration conf) throws ClassNotFoundException, SQLException {
        this.conf = conf;
        this.fileSystem = new FileSystem(conf);
        Class.forName(jdbcDriver.class.getName());
        this.jdbcUrl = HSQLDB_JDBC_URL_PREFIX + conf.getSourcePath() + File.separator + HSQLDB_DB_NAME + ";shutdown=false";
        this.conn = DriverManager.getConnection(this.jdbcUrl, "sa", "");
        this.conn.setAutoCommit(true);
        this.viewname = "USER_EX" + Utilities.randomNumber();
        this.query = "SELECT * FROM " + this.viewname;
        this.fileToDB = new FileToDB(this);
    }

    public static CSVDirConnection openConnection(CSVDirConfiguration configuration) throws ClassNotFoundException, SQLException {
        return new CSVDirConnection(configuration);
    }

    public void closeConnection() throws SQLException {
        if (this.conn != null) {
            LOG.ok("Closing connection ...", new Object[0]);
            this.dropTableAndViewIfExists();
            this.conn.close();
            this.tables.clear();
        }
    }

    public int insertAccount(Map<String, String> attributes) {
        String tableName = this.fileToDB.createDbForCreate();
        this.tables.add(tableName);
        return this.execute(QueryCreator.insertQuery(attributes, tableName));
    }

    public int updateAccount(Map<String, String> attrToBeReplaced, Uid uid) {
        File[] files = this.fileSystem.getAllCsvFiles();
        if (files.length == 0) {
            throw new ConnectorException("Empty table");
        }
        int returnValue = 0;
        for (File file : files) {
            String tableName = this.fileToDB.createDbForUpdate(file);
            this.tables.add(tableName);
            returnValue += this.execute(QueryCreator.updateQuery(attrToBeReplaced, uid, this.conf.getKeyseparator(), this.conf.getKeyColumnNames(), tableName));
        }
        return returnValue;
    }

    public int deleteAccount(Uid uid) {
        File[] files = this.fileSystem.getAllCsvFiles();
        if (files.length == 0) {
            throw new ConnectorException("Empty table");
        }
        int returnValue = 0;
        for (File file : files) {
            String tableName = this.fileToDB.createDbForUpdate(file);
            this.tables.add(tableName);
            returnValue += this.execute(QueryCreator.deleteQuery(uid, this.conf.getKeyseparator(), this.conf.getKeyColumnNames(), tableName));
        }
        return returnValue;
    }

    private int execute(String query) {
        PreparedStatement stm = null;
        LOG.ok("About to execute {0}", new Object[]{query});
        try {
            stm = this.conn.prepareStatement(query);
            int n = stm.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "Error during sql query", new Object[0]);
            throw new IllegalStateException(e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "While closing sql statement", new Object[0]);
            }
        }
    }

    public final ResultSet modifiedCsvFiles(long syncToken) throws SQLException {
        List<String> tableNames = this.fileToDB.createDbForSync(this.fileSystem.getModifiedCsvFiles(syncToken));
        this.tables.addAll(tableNames);
        return this.doQuery(this.conn.prepareStatement(this.query));
    }

    public ResultSet allCsvFiles() {
        List<String> tableNames = this.fileToDB.createDbForSync(this.fileSystem.getAllCsvFiles());
        this.tables.addAll(tableNames);
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepareStatement(this.query);
            ResultSet resultSet = this.doQuery(stmt);
            return resultSet;
        }
        catch (SQLException ex) {
            LOG.error((Throwable)ex, "Error during sql query", new Object[0]);
            throw new IllegalStateException(ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LOG.error((Throwable)ex, "While closing sql statement", new Object[0]);
                }
            }
        }
    }

    public ResultSet allCsvFiles(String where, List<SQLParam> params) {
        List<String> tableNames = this.fileToDB.createDbForSync(this.fileSystem.getAllCsvFiles());
        this.tables.addAll(tableNames);
        Statement stmt = null;
        try {
            stmt = this.conn.prepareStatement(this.query + (where != null && !where.isEmpty() ? " WHERE " + where : ""));
            SQLUtil.setParams((PreparedStatement)stmt, params);
            ResultSet resultSet = this.doQuery((PreparedStatement)stmt);
            return resultSet;
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "Error during sql query", new Object[0]);
            throw new IllegalStateException(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                LOG.error((Throwable)ex, "While closing sql statement", new Object[0]);
            }
        }
    }

    private ResultSet doQuery(PreparedStatement stm) throws SQLException {
        LOG.ok("Execute query {0}", new Object[]{stm.toString()});
        return stm.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableAndViewIfExists() throws SQLException {
        LOG.ok("Drop view {0}", new Object[]{this.viewname});
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.execute("DROP VIEW " + this.viewname + " IF EXISTS CASCADE");
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        for (String table : this.tables) {
            LOG.ok("Drop table {0}", new Object[]{table});
            try {
                stmt = this.conn.createStatement();
                stmt.execute("DROP TABLE " + table + " IF EXISTS CASCADE");
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
            }
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getViewname() {
        return this.viewname;
    }

    public Connection getConn() {
        return this.conn;
    }

    public CSVDirConfiguration getConf() {
        return this.conf;
    }

    public Set<String> getTables() {
        return this.tables;
    }
}

