/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.crud;

import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import net.tirasa.adsddl.ntsd.utils.GUID;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.util.ADGuardedPasswordAttribute;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.LdapModifyOperation;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class ADCreate
extends LdapModifyOperation {
    private static final Log LOG = Log.getLog(ADConnection.class);
    private final ObjectClass oclass;
    private final Set<Attribute> attrs;
    private final ADConnection conn;

    public ADCreate(ADConnection conn, ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        super((LdapConnection)conn);
        this.oclass = oclass;
        this.attrs = attrs;
        this.conn = conn;
    }

    public Uid create() {
        try {
            return this.executeImpl();
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private Uid executeImpl() throws NamingException {
        Name name;
        Name nameAttr = AttributeUtil.getNameFromAttributes(this.attrs);
        if (nameAttr == null) {
            throw new IllegalArgumentException("No Name attribute provided in the attributes");
        }
        Attribute cnAttr = AttributeUtil.find((String)"CN", this.attrs);
        if (cnAttr != null) {
            this.attrs.remove(cnAttr);
        }
        ADUtilities utils = new ADUtilities(this.conn);
        if (ADUtilities.isDN(nameAttr.getNameValue())) {
            name = nameAttr;
        } else {
            if (AttributeUtil.getUidAttribute(this.attrs) == null && StringUtil.isNotBlank((String)nameAttr.getNameValue())) {
                this.attrs.add((Attribute)new Uid(nameAttr.getNameValue()));
            }
            name = new Name(utils.getDN(this.oclass, nameAttr, cnAttr));
        }
        List ldapGroups = null;
        String primaryGroupDN = null;
        ADGuardedPasswordAttribute pwdAttr = null;
        final BasicAttributes adAttrs = new BasicAttributes(true);
        int uacValue = -1;
        Boolean uccp = null;
        for (Attribute attr : this.attrs) {
            javax.naming.directory.Attribute ldapAttr;
            List value;
            if (attr.is(Name.NAME)) continue;
            if (attr.is("userCannotChangePassword")) {
                value = attr.getValue();
                if (value == null || value.isEmpty()) continue;
                uccp = (Boolean)value.get(0);
                continue;
            }
            if (attr.is("primaryGroupDN")) {
                value = attr.getValue();
                primaryGroupDN = value == null || value.isEmpty() ? null : (String)String.class.cast(value.get(0));
                continue;
            }
            if (attr.is("pwdLastSet")) {
                value = attr.getValue();
                if (value == null || value.isEmpty() || !((Boolean)value.get(0)).booleanValue()) continue;
                adAttrs.put(new BasicAttribute("pwdLastSet", "0"));
                continue;
            }
            if (attr.is("lockoutTime")) {
                value = attr.getValue();
                if (value == null || value.isEmpty() || !((Boolean)value.get(0)).booleanValue()) continue;
                adAttrs.put(new BasicAttribute("lockoutTime", "0"));
                continue;
            }
            if (LdapConstants.isLdapGroups((String)attr.getName())) {
                ldapGroups = LdapUtil.checkedListByFilter((List)CollectionUtil.nullAsEmpty((List)attr.getValue()), String.class);
                continue;
            }
            if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                pwdAttr = ADGuardedPasswordAttribute.create(this.conn.getConfiguration().getPasswordAttribute(), attr);
                continue;
            }
            if (attr.is("userAccountControl") && this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                uacValue = attr.getValue() == null || attr.getValue().isEmpty() ? -1 : Integer.parseInt(attr.getValue().get(0).toString());
                continue;
            }
            if (attr.is(OperationalAttributes.ENABLE_NAME) && this.oclass.is(ObjectClass.ACCOUNT_NAME) && uacValue == -1) {
                if (attr.getValue() == null || attr.getValue().isEmpty() || Boolean.parseBoolean(attr.getValue().get(0).toString())) {
                    uacValue = 512;
                    continue;
                }
                uacValue = 514;
                continue;
            }
            if (attr.is("objectGUID") || (ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, attr)) == null || ldapAttr.size() <= 0) continue;
            adAttrs.put(ldapAttr);
        }
        String pwdAttrName = this.conn.getConfiguration().getPasswordAttribute();
        if (this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
            if (pwdAttr != null) {
                pwdAttr.access(new ADGuardedPasswordAttribute.Accessor(){

                    @Override
                    public void access(BasicAttribute attr) {
                        try {
                            if (attr.get() != null && !attr.get().toString().isEmpty()) {
                                adAttrs.put(attr);
                            }
                        }
                        catch (NamingException e) {
                            LOG.error((Throwable)e, "Error retrieving password value", new Object[0]);
                        }
                    }
                });
            }
            if (adAttrs.get(pwdAttrName) != null) {
                adAttrs.put("userAccountControl", Integer.toString(uacValue));
            } else {
                adAttrs.put("userAccountControl", Integer.toString(514));
            }
        }
        String entryDN = this.conn.getSchemaMapping().create(this.oclass, name, (Attributes)adAttrs);
        if (uccp != null) {
            this.conn.getInitialContext().modifyAttributes(entryDN, new ModificationItem[]{new ModificationItem(2, utils.userCannotChangePassword(entryDN, uccp))});
        }
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.addLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (StringUtil.isNotBlank(primaryGroupDN)) {
            this.conn.getInitialContext().modifyAttributes(entryDN, new ModificationItem[]{new ModificationItem(2, utils.getGroupID(primaryGroupDN))});
        }
        if ("objectGUID".equals(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
            Attributes profile = this.conn.getInitialContext().getAttributes(entryDN, new String[]{"objectGUID"});
            return new Uid(GUID.getGuidAsString((byte[])((byte[])profile.get("objectGUID").get())));
        }
        return this.conn.getSchemaMapping().createUid(this.oclass, entryDN);
    }
}

