/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.tirasa.connid.bundles.ad.search.ADDefaultSearchStrategy;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ldap.LdapConfiguration;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.ObjectClassMappingConfig;
import net.tirasa.connid.bundles.ldap.search.DefaultSearchStrategy;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class ADConfiguration
extends LdapConfiguration {
    private final Log LOG = Log.getLog(ADConfiguration.class);
    private boolean ssl = true;
    private boolean retrieveDeletedUser = true;
    private boolean retrieveDeletedGroup = true;
    public static final String PROMPT_USER_FLAG = "pwdLastSet";
    public static final String PROMPT_USER_VALUE = "0";
    public static final String LOCK_OUT_FLAG = "lockoutTime";
    public static final String LOCK_OUT_DEFAULT_VALUE = "0";
    public static final String UCCP_FLAG = "userCannotChangePassword";
    public static final String CN_NAME = "CN";
    public static final String PRIMARY_GROUP_DN_NAME = "primaryGroupDN";
    private List<String> memberships;
    private boolean membershipConservativePolicy;
    private boolean trustAllCerts;
    private boolean membershipsInOr = false;
    private boolean startSyncFromToday = true;
    private String defaultPeopleContainer;
    private String defaultGroupContainer;
    private SearchScope userSearchScope;
    private SearchScope groupSearchScope;
    private String groupSearchFilter;
    private String[] groupBaseContexts = new String[0];
    private String[] userBaseContexts = new String[0];
    private String groupMemberReferenceAttribute = "member";
    private String groupOwnerReferenceAttribute = "managedBy";
    private boolean pwdUpdateOnly = false;
    private final ObjectClassMappingConfig accountConfig = new ObjectClassMappingConfig(ObjectClass.ACCOUNT, CollectionUtil.newList((Object[])new String[]{"top", "person", "organizationalPerson", "user"}), false, CollectionUtil.newList((Object[])new String[]{"sAMAccountName", "cn", "member"}), new AttributeInfo[]{LdapConstants.PASSWORD});
    private final ObjectClassMappingConfig groupConfig = new ObjectClassMappingConfig(ObjectClass.GROUP, CollectionUtil.newList((Object[])new String[]{"top", "group"}), false, Collections.emptyList(), new AttributeInfo[0]);

    public ADConfiguration() {
        this.setUidAttribute("sAMAccountName");
        this.setSynchronizePasswords(false);
        this.setAccountUserNameAttributes(new String[]{"sAMAccountName"});
        this.setObjectClassesToSynchronize(new String[]{"user"});
        this.setGroupMemberAttribute("member");
        this.setPasswordAttribute("unicodePwd");
        this.setPort(636);
        this.memberships = new ArrayList<String>();
        this.userSearchScope = SearchScope.subtree;
        this.groupSearchScope = SearchScope.subtree;
    }

    public DefaultSearchStrategy newDefaultSearchStrategy(boolean ignoreNonExistingBaseDN) {
        return new ADDefaultSearchStrategy(ignoreNonExistingBaseDN);
    }

    @ConfigurationProperty(displayMessageKey="ssl.display", helpMessageKey="ssl.help", order=1)
    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        super.setSsl(ssl);
        this.ssl = ssl;
    }

    public Map<ObjectClass, ObjectClassMappingConfig> getObjectClassMappingConfigs() {
        HashMap<ObjectClass, ObjectClassMappingConfig> result = new HashMap<ObjectClass, ObjectClassMappingConfig>();
        result.put(this.accountConfig.getObjectClass(), this.accountConfig);
        result.put(this.groupConfig.getObjectClass(), this.groupConfig);
        return result;
    }

    @ConfigurationProperty(displayMessageKey="memberships.display", helpMessageKey="memberships.help", order=1)
    public String[] getMemberships() {
        return this.memberships.toArray(new String[this.memberships.size()]);
    }

    public void setMemberships(String ... memberships) {
        this.memberships = new ArrayList<String>();
        if (memberships != null) {
            for (String membership : memberships) {
                if (ADUtilities.isDN(membership)) {
                    this.memberships.add(membership.trim());
                    continue;
                }
                this.LOG.warn("Skip membership! \"{0}\" is not a valid distinguished name (DN)", new Object[]{membership});
            }
        }
    }

    @ConfigurationProperty(displayMessageKey="retrieveDeletedUser.display", helpMessageKey="retrieveDeletedUser.help", order=2)
    public boolean isRetrieveDeletedUser() {
        return this.retrieveDeletedUser;
    }

    public void setRetrieveDeletedUser(boolean retrieveDeletedUser) {
        this.retrieveDeletedUser = retrieveDeletedUser;
    }

    @ConfigurationProperty(displayMessageKey="retrieveDeletedGroup.display", helpMessageKey="retrieveDeletedGroup.help", order=3)
    public boolean isRetrieveDeletedGroup() {
        return this.retrieveDeletedGroup;
    }

    public void setRetrieveDeletedGroup(boolean retrieveDeletedGroup) {
        this.retrieveDeletedGroup = retrieveDeletedGroup;
    }

    @ConfigurationProperty(displayMessageKey="trustAllCerts.display", helpMessageKey="trustAllCerts.help", order=4)
    public boolean isTrustAllCerts() {
        return this.trustAllCerts;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public boolean isMembershipsInOr() {
        return this.membershipsInOr;
    }

    @ConfigurationProperty(displayMessageKey="membershipsInOr.display", helpMessageKey="membershipsInOr.help", order=5)
    public void setMembershipsInOr(boolean membershipsInOr) {
        this.membershipsInOr = membershipsInOr;
    }

    @ConfigurationProperty(order=6, required=true, displayMessageKey="baseContextsToSynchronize.display", helpMessageKey="baseContextsToSynchronize.help")
    public String[] getBaseContextsToSynchronize() {
        return super.getBaseContextsToSynchronize();
    }

    public void setBaseContextsToSynchronize(String ... baseContextsToSynchronize) {
        super.setBaseContextsToSynchronize(baseContextsToSynchronize);
    }

    @ConfigurationProperty(displayMessageKey="defaultPeopleContainer.display", helpMessageKey="defaultPeopleContainer.help", order=7)
    public String getDefaultPeopleContainer() {
        if (StringUtil.isBlank((String)this.defaultPeopleContainer)) {
            return this.getBaseContextsToSynchronize() == null || this.getBaseContextsToSynchronize().length < 1 ? null : this.getBaseContextsToSynchronize()[0];
        }
        return this.defaultPeopleContainer;
    }

    public void setDefaultPeopleContainer(String defaultPeopleContainer) {
        this.defaultPeopleContainer = defaultPeopleContainer;
    }

    @ConfigurationProperty(displayMessageKey="defaultGroupContainer.display", helpMessageKey="defaultGroupContainer.help", order=8)
    public String getDefaultGroupContainer() {
        if (StringUtil.isBlank((String)this.defaultGroupContainer)) {
            return this.getBaseContextsToSynchronize() == null || this.getBaseContextsToSynchronize().length < 1 ? null : this.getBaseContextsToSynchronize()[0];
        }
        return this.defaultGroupContainer;
    }

    public void setDefaultGroupContainer(String defaultGroupContainer) {
        this.defaultGroupContainer = defaultGroupContainer;
    }

    @ConfigurationProperty(displayMessageKey="userSearchScope.display", helpMessageKey="userSearchScope.help", order=9)
    public String getUserSearchScope() {
        return this.userSearchScope == null ? SearchScope.subtree.toString() : this.userSearchScope.toString();
    }

    public void setUserSearchScope(String userSearchScope) {
        this.userSearchScope = SearchScope.valueOf(userSearchScope.toLowerCase());
    }

    @ConfigurationProperty(displayMessageKey="groupSearchScope.display", helpMessageKey="groupSearchScope.help", order=10)
    public String getGroupSearchScope() {
        return this.groupSearchFilter == null ? SearchScope.subtree.toString() : this.groupSearchScope.toString();
    }

    public void setGroupSearchScope(String groupSearchScope) {
        this.groupSearchScope = SearchScope.valueOf(groupSearchScope.toLowerCase());
    }

    @ConfigurationProperty(displayMessageKey="groupSearchFilter.display", helpMessageKey="groupSearchFilter.help", order=11)
    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    @ConfigurationProperty(displayMessageKey="groupBaseContexts.display", helpMessageKey="groupBaseContexts.help", order=12)
    public String[] getGroupBaseContexts() {
        if (this.groupBaseContexts != null && this.groupBaseContexts.length > 0) {
            return (String[])this.groupBaseContexts.clone();
        }
        return this.getBaseContextsToSynchronize();
    }

    public void setGroupBaseContexts(String ... baseContexts) {
        this.groupBaseContexts = (String[])baseContexts.clone();
        super.setBaseContexts(this.getBaseContexts());
    }

    @ConfigurationProperty(displayMessageKey="userBaseContexts.display", helpMessageKey="userBaseContexts.help", order=13)
    public String[] getUserBaseContexts() {
        if (this.userBaseContexts != null && this.userBaseContexts.length > 0) {
            return (String[])this.userBaseContexts.clone();
        }
        return this.getBaseContextsToSynchronize();
    }

    public void setUserBaseContexts(String ... baseContexts) {
        this.userBaseContexts = (String[])baseContexts.clone();
        super.setBaseContexts(this.getBaseContexts());
    }

    public String[] getBaseContexts() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(Arrays.asList(this.getUserBaseContexts()));
        res.addAll(Arrays.asList(this.getGroupBaseContexts()));
        return res.toArray(new String[res.size()]);
    }

    @ConfigurationProperty(displayMessageKey="groupMemberReferenceAttribute.display", helpMessageKey="groupMemberReferenceAttribute.help", order=14)
    public String getGroupMemberReferenceAttribute() {
        return StringUtil.isBlank((String)this.groupMemberReferenceAttribute) ? "member" : this.groupMemberReferenceAttribute;
    }

    public void setGroupMemberReferenceAttribute(String groupMemberReferenceAttribute) {
        this.groupMemberReferenceAttribute = groupMemberReferenceAttribute;
    }

    @ConfigurationProperty(displayMessageKey="groupOwnerReferenceAttribute.display", helpMessageKey="groupOwnerReferenceAttribute.help", order=15)
    public String getGroupOwnerReferenceAttribute() {
        return StringUtil.isBlank((String)this.groupOwnerReferenceAttribute) ? "managedBy" : this.groupOwnerReferenceAttribute;
    }

    public void setGroupOwnerReferenceAttribute(String groupOwnerReferenceAttribute) {
        this.groupOwnerReferenceAttribute = groupOwnerReferenceAttribute;
    }

    @ConfigurationProperty(displayMessageKey="startSyncFromToday.display", helpMessageKey="startSyncFromToday.help", order=16)
    public boolean isStartSyncFromToday() {
        return this.startSyncFromToday;
    }

    public void setStartSyncFromToday(boolean startSyncFromToday) {
        this.startSyncFromToday = startSyncFromToday;
    }

    public boolean isPwdUpdateOnly() {
        return this.pwdUpdateOnly;
    }

    @ConfigurationProperty(displayMessageKey="pwdUpdateOnly.display", helpMessageKey="pwdUpdateOnly.help", required=true, order=17)
    public void setPwdUpdateOnly(boolean pwdUpdateOnly) {
        this.pwdUpdateOnly = pwdUpdateOnly;
    }

    @ConfigurationProperty(displayMessageKey="membershipConservativePolicy.display", helpMessageKey="membershipConservativePolicy.help", order=18)
    public boolean isMembershipConservativePolicy() {
        return this.membershipConservativePolicy;
    }

    public void setMembershipConservativePolicy(boolean membershipConservativePolicy) {
        this.membershipConservativePolicy = membershipConservativePolicy;
    }

    public final void setUidAttribute(String uidAttribute) {
        this.setAccountUserNameAttributes(new String[]{"sAMAccountName", uidAttribute});
        super.setUidAttribute(uidAttribute);
    }

    public static enum SearchScope {
        object,
        onelevel,
        subtree;

    }
}

