/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.tools.journal;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractJournalOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.CommitOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalException;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalRecovery;

public class JournalDumpTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DataInputStream in;
        if (args.length != 1) {
            throw new IllegalArgumentException("Expected one parameter : <journalFile>");
        }
        File journalFile = new File(args[0]);
        System.out.println("---------------------------------------------------------------------------------------");
        System.out.println("Dump of journal file : " + journalFile.getAbsolutePath());
        System.out.println("---------------------------------------------------------------------------------------");
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(journalFile)));
        }
        catch (IOException e) {
            throw new JournalException("Cannot open journal file : " + journalFile.getAbsolutePath(), (Exception)e);
        }
        try {
            AbstractJournalOperation op;
            while ((op = JournalRecovery.readJournalOperation((DataInputStream)in)) != null) {
                System.out.println(op);
                if (!(op instanceof CommitOperation)) continue;
                System.out.println("----------------------------------------------------------------------");
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new JournalException("Cannot close journal file : " + journalFile.getAbsolutePath(), (Exception)e);
            }
        }
    }
}

