/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.management.DescriptorTools;
import net.timewalker.ffmq4.management.bridge.BridgeDefinition;
import net.timewalker.ffmq4.management.bridge.handler.BridgeDescriptorHandler;
import net.timewalker.ffmq4.utils.xml.XMLDescriptorReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BridgeDefinitionProvider {
    private static final Log log = LogFactory.getLog(BridgeDefinitionProvider.class);
    private File bridgeDefinitionsDir;
    private List<BridgeDefinition> bridgeDefinitionList = new Vector<BridgeDefinition>();
    private Set<String> bridgeNames = new HashSet<String>();

    public BridgeDefinitionProvider(File bridgeDefinitionsDir) {
        this.bridgeDefinitionsDir = bridgeDefinitionsDir;
    }

    public BridgeDefinition[] getBridgeDefinitions() {
        return this.bridgeDefinitionList.toArray(new BridgeDefinition[this.bridgeDefinitionList.size()]);
    }

    public void loadExistingDefinitions() throws JMSException {
        log.info((Object)("Loading existing bridge definitions from : " + this.bridgeDefinitionsDir.getAbsolutePath()));
        File[] bridgeDescriptors = DescriptorTools.getDescriptorFiles((File)this.bridgeDefinitionsDir, (String)"bridge-", (String)".xml");
        if (bridgeDescriptors != null) {
            for (int i = 0; i < bridgeDescriptors.length; ++i) {
                BridgeDefinition bridgeDef = this.loadBridgeDefinition(bridgeDescriptors[i]);
                if (bridgeDef == null) continue;
                this.addBridgeDefinition(bridgeDef);
            }
        }
        log.debug((Object)("Loaded " + this.bridgeDefinitionList.size() + " bridge definitions"));
    }

    public void addBridgeDefinition(BridgeDefinition bridgeDef) throws JMSException {
        bridgeDef.check();
        if (!this.bridgeNames.add(bridgeDef.getName())) {
            throw new FFMQException("Bridge name already exists : " + bridgeDef.getName(), "BRIDGE_ALREADY_EXIST");
        }
        this.bridgeDefinitionList.add(bridgeDef);
    }

    private BridgeDefinition loadBridgeDefinition(File bridgeDescriptor) throws JMSException {
        if (!bridgeDescriptor.exists()) {
            return null;
        }
        if (!bridgeDescriptor.canRead()) {
            throw new FFMQException("Cannot access bridge definition descriptor : " + bridgeDescriptor.getAbsolutePath(), "FS_ERROR");
        }
        return (BridgeDefinition)new XMLDescriptorReader().read(bridgeDescriptor, BridgeDescriptorHandler.class);
    }
}

