/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.admin;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.FFMQServer;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.local.connection.LocalQueueConnection;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.management.destination.definition.TopicDefinition;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.concurrent.SynchronizableThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RemoteAdministrationThread
extends SynchronizableThread {
    private static final Log log = LogFactory.getLog(RemoteAdministrationThread.class);
    protected FFMQServer server;
    private FFMQEngine engine;
    private QueueConnection conn = null;
    private QueueSession session = null;
    private QueueSender sender = null;
    private QueueReceiver receiver = null;
    private boolean stopRequired = false;

    public RemoteAdministrationThread(FFMQServer server, FFMQEngine engine) {
        super("FFMQ-RemoteAdminThread");
        this.server = server;
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info((Object)"Starting remote administration thread ...");
        try {
            Message message;
            LocalQueue inputQueue = this.engine.getLocalQueue("_FFMQ_ADM_REQUEST");
            LocalQueue outputQueue = this.engine.getLocalQueue("_FFMQ_ADM_REPLY");
            this.conn = new LocalQueueConnection(this.engine, null, null);
            this.session = this.conn.createQueueSession(true, 0);
            this.receiver = this.session.createReceiver((Queue)inputQueue);
            this.sender = this.session.createSender((Queue)outputQueue);
            this.conn.start();
            inputQueue.purge(null);
            outputQueue.purge(null);
            this.notifyStartup();
            while (!this.stopRequired && (message = this.receiver.receive()) != null) {
                log.debug((Object)("Received message " + message));
                try {
                    String errorMsg = this.process(message);
                    Message response = this.session.createMessage();
                    response.setJMSCorrelationID(message.getJMSMessageID());
                    if (errorMsg != null) {
                        response.setStringProperty("FFMQ_ADM_errorMessage", errorMsg);
                    }
                    this.sender.send(response, 1, 4, 0L);
                }
                catch (JMSException e) {
                    log.error((Object)"Cannot process admin command", (Throwable)e);
                }
                finally {
                    this.session.commit();
                }
            }
            log.debug((Object)"Remote administration thread has stopped");
        }
        catch (Throwable e) {
            log.fatal((Object)"Administration thread failed", e);
            this.notifyStartup();
        }
        finally {
            try {
                if (this.sender != null) {
                    this.sender.close();
                }
            }
            catch (JMSException e) {
                ErrorTools.log((JMSException)e, (Log)log);
            }
            try {
                if (this.receiver != null) {
                    this.receiver.close();
                }
            }
            catch (JMSException e) {
                ErrorTools.log((JMSException)e, (Log)log);
            }
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (JMSException e) {
                ErrorTools.log((JMSException)e, (Log)log);
            }
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (JMSException e) {
                ErrorTools.log((JMSException)e, (Log)log);
            }
        }
    }

    private String process(Message msg) {
        try {
            String command = msg.getStringProperty("FFMQ_ADM_adminCommand");
            if (StringTools.isEmpty((String)command)) {
                return "Administration command not set in message header";
            }
            if (command.equals("createQueue")) {
                return this.processCreateQueue(msg);
            }
            if (command.equals("createTopic")) {
                return this.processCreateTopic(msg);
            }
            if (command.equals("deleteQueue")) {
                return this.processDeleteQueue(msg);
            }
            if (command.equals("deleteTopic")) {
                return this.processDeleteTopic(msg);
            }
            if (command.equals("purgeQueue")) {
                return this.processPurgeQueue(msg);
            }
            if (command.equals("shutdown")) {
                return this.processShutdown();
            }
            log.error((Object)("Invalid administration command : " + command));
            return "Invalid administration command : " + command;
        }
        catch (JMSException e) {
            ErrorTools.log((JMSException)e, (Log)log);
            return "Error processing administration command : " + e.getMessage();
        }
        catch (Exception e) {
            ErrorTools.log((JMSException)new FFMQException("Cannot process admin message", "INVALID_ADMIN_MESSAGE", (Throwable)e), (Log)log);
            return "Error processing administration command : " + e.getMessage();
        }
    }

    private Settings createSettings(Message msg) throws JMSException {
        Settings queueSettings = new Settings();
        Enumeration headers = msg.getPropertyNames();
        while (headers.hasMoreElements()) {
            String propName = (String)headers.nextElement();
            if (propName.startsWith("FFMQ_ADM_")) continue;
            String propValue = msg.getStringProperty(propName);
            queueSettings.setStringProperty(propName, propValue);
        }
        return queueSettings;
    }

    private String processCreateQueue(Message msg) throws JMSException {
        Settings queueSettings = this.createSettings(msg);
        QueueDefinition queueDef = new QueueDefinition(queueSettings);
        log.debug((Object)("Creating queue : " + queueDef));
        this.engine.createQueue(queueDef);
        return null;
    }

    private String processCreateTopic(Message msg) throws JMSException {
        Settings topicSettings = this.createSettings(msg);
        TopicDefinition topicDef = new TopicDefinition(topicSettings);
        log.debug((Object)("Creating topic : " + topicDef));
        this.engine.createTopic(topicDef);
        return null;
    }

    private String processDeleteQueue(Message msg) throws JMSException {
        String destName = msg.getStringProperty("name");
        if (StringTools.isEmpty((String)destName)) {
            return "Destination name not specified";
        }
        if (!this.engine.localQueueExists(destName)) {
            return "Queue " + destName + " does not exist";
        }
        this.engine.deleteQueue(destName);
        return null;
    }

    private String processDeleteTopic(Message msg) throws JMSException {
        String destName = msg.getStringProperty("name");
        if (StringTools.isEmpty((String)destName)) {
            return "Destination name not specified";
        }
        if (!this.engine.localTopicExists(destName)) {
            return "Topic " + destName + " does not exist";
        }
        this.engine.deleteTopic(destName);
        return null;
    }

    private String processPurgeQueue(Message msg) throws JMSException {
        String destName = msg.getStringProperty("name");
        if (StringTools.isEmpty((String)destName)) {
            return "Destination name not specified";
        }
        if (!this.engine.localQueueExists(destName)) {
            return "Queue " + destName + " does not exist";
        }
        LocalQueue queue = this.engine.getLocalQueue(destName);
        queue.purge(null);
        return null;
    }

    private String processShutdown() {
        if (this.server.isInRunnableMode()) {
            this.server.pleaseStop();
        } else {
            new Thread(){

                @Override
                public void run() {
                    RemoteAdministrationThread.this.server.shutdown();
                }
            }.start();
        }
        return null;
    }

    public void pleaseStop() {
        if (this.stopRequired) {
            return;
        }
        this.stopRequired = true;
        try {
            if (this.receiver != null) {
                this.receiver.close();
            }
        }
        catch (JMSException e) {
            ErrorTools.log((JMSException)e, (Log)log);
        }
    }
}

