/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4;

import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import javax.management.ObjectName;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.FFMQServerMBean;
import net.timewalker.ffmq4.FFMQVersion;
import net.timewalker.ffmq4.admin.RemoteAdministrationThread;
import net.timewalker.ffmq4.cluster.bridge.JMSBridge;
import net.timewalker.ffmq4.jmx.JMXAgent;
import net.timewalker.ffmq4.jmx.rmi.JMXOverRMIAgent;
import net.timewalker.ffmq4.listeners.ClientListener;
import net.timewalker.ffmq4.listeners.tcp.io.TcpListener;
import net.timewalker.ffmq4.listeners.tcp.nio.NIOTcpListener;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.local.FFMQEngineListener;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.destination.LocalTopic;
import net.timewalker.ffmq4.management.BridgeDefinitionProvider;
import net.timewalker.ffmq4.management.bridge.BridgeDefinition;
import net.timewalker.ffmq4.utils.InetUtils;
import net.timewalker.ffmq4.utils.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FFMQServer
implements FFMQServerMBean,
FFMQEngineListener,
Runnable {
    private static final Log log = LogFactory.getLog(FFMQServer.class);
    private static final int ADMIN_THREAD_STOP_TIMEOUT = 30;
    private String engineName;
    private Settings settings;
    private long startupTime;
    private JMXAgent jmxAgent;
    private FFMQEngine engine;
    private ClientListener tcpListener;
    private RemoteAdministrationThread adminThread;
    private BridgeDefinitionProvider bridgeDefinitionProvider;
    private List<JMSBridge> bridges = new Vector<JMSBridge>();
    private boolean started;
    private boolean stopRequired;
    private boolean inRunnableMode;

    public FFMQServer(String engineName, Settings settings) throws JMSException {
        this.engineName = engineName;
        this.settings = settings;
        this.init();
    }

    private void init() throws JMSException {
        String bridgeDefinitionDirPath = this.settings.getStringProperty("management.bridgeDefinitions.directory", null);
        if (bridgeDefinitionDirPath != null) {
            File bridgeDefinitionsDir = new File(bridgeDefinitionDirPath);
            if (!bridgeDefinitionsDir.isDirectory()) {
                throw new FFMQException("Bridge definitions directory does not exist : " + bridgeDefinitionsDir.getAbsolutePath(), "FS_ERROR");
            }
            this.bridgeDefinitionProvider = new BridgeDefinitionProvider(bridgeDefinitionsDir);
        }
    }

    @Override
    public String getVersion() {
        return FFMQVersion.getProviderMajorVersion() + "." + FFMQVersion.getProviderMinorVersion() + "." + FFMQVersion.getProviderReleaseVersion();
    }

    @Override
    public synchronized boolean start() {
        if (this.started) {
            return false;
        }
        try {
            boolean remoteAdminEnabled;
            long startTime = System.currentTimeMillis();
            log.info((Object)("FFMQ server " + this.getVersion() + " (Java " + System.getProperty("java.version") + ")"));
            log.info((Object)("Running on " + System.getProperty("os.name", "?") + " " + System.getProperty("os.version", "?")));
            log.info((Object)("JVM is " + System.getProperty("java.vm.vendor", "?") + " " + System.getProperty("java.runtime.version", "?") + " [" + System.getProperty("java.vm.name", "?") + "] at " + System.getProperty("java.home", "?")));
            log.info((Object)("Server local engine name is '" + this.engineName + "'"));
            log.debug((Object)"Server startup ...");
            boolean jmxAgentEnabled = this.settings.getBooleanProperty("management.jmx.agent.enabled", false);
            int jmxJndiRmiPort = this.settings.getIntProperty("management.jmx.agent.jndi.rmi.port", 10003);
            String jmxRmiListenAddr = InetUtils.resolveAutoInterfaceAddress(this.settings.getStringProperty("management.jmx.agent.rmi.listenAddr", "0.0.0.0"));
            if (jmxAgentEnabled) {
                this.jmxAgent = new JMXOverRMIAgent("FFMQ-server", jmxJndiRmiPort, jmxRmiListenAddr);
                try {
                    this.jmxAgent.register(new ObjectName("FFMQ:type=Server"), this);
                }
                catch (Exception e) {
                    log.error((Object)"Cannot register server on JMX agent", (Throwable)e);
                }
            }
            this.engine = new FFMQEngine(this.engineName, this.settings, (FFMQEngineListener)this);
            try {
                if (this.jmxAgent != null) {
                    this.jmxAgent.register(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName()), this.engine);
                }
            }
            catch (Exception e) {
                log.error((Object)"Cannot register local engine on JMX agent", (Throwable)e);
            }
            this.engine.deploy();
            String listenAddr = InetUtils.resolveAutoInterfaceAddress(this.settings.getStringProperty("listener.tcp.listenAddr", null));
            int listenPort = this.settings.getIntProperty("listener.tcp.listenPort", 10002);
            boolean tcpListenerEnabled = this.settings.getBooleanProperty("listener.tcp.enabled", true);
            boolean useNIOListener = this.settings.getBooleanProperty("listener.tcp.useNIO", false);
            boolean useSSL = this.settings.getBooleanProperty("transport.tcp.ssl.enabled", false);
            if (useSSL && useNIOListener) {
                throw new FFMQException("Cannot enable SSL & NIO listener at the same time.", "CONFIGURATION_ERROR");
            }
            if (tcpListenerEnabled) {
                this.tcpListener = useNIOListener ? new NIOTcpListener(this.engine, listenAddr, listenPort, this.settings, this.jmxAgent) : new TcpListener(this.engine, listenAddr, listenPort, this.settings, this.jmxAgent);
                if (this.jmxAgent != null) {
                    try {
                        this.jmxAgent.register(new ObjectName("FFMQ:type=Listeners,listener=" + this.tcpListener.getName()), this.tcpListener);
                    }
                    catch (Exception e) {
                        log.error((Object)"Cannot register listener on JMX agent", (Throwable)e);
                    }
                }
                this.tcpListener.start();
            }
            if (remoteAdminEnabled = this.settings.getBooleanProperty("management.remoteAdmin.enabled", false)) {
                this.adminThread = new RemoteAdministrationThread(this, this.engine);
                this.adminThread.start();
                try {
                    this.adminThread.waitForStartup();
                }
                catch (InterruptedException e) {
                    throw new FFMQException("Deploy was interrupted while waiting for the admin thread to start", "INTERNAL_ERROR");
                }
            }
            this.deployBridges();
            long endTime = System.currentTimeMillis();
            log.info((Object)("Server startup complete. (" + (endTime - startTime) + " ms)"));
            this.started = true;
            this.startupTime = System.currentTimeMillis();
            return true;
        }
        catch (JMSException e) {
            if (e.getLinkedException() != null) {
                log.error((Object)"Server startup failed", (Throwable)e);
                log.error((Object)"Original error was :", (Throwable)e.getLinkedException());
            } else {
                log.error((Object)"Server startup failed", (Throwable)e);
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Server startup failed", (Throwable)e);
            return false;
        }
    }

    private void deployBridges() throws JMSException {
        if (this.bridgeDefinitionProvider != null) {
            this.bridgeDefinitionProvider.loadExistingDefinitions();
            BridgeDefinition[] bridgeDefs = this.bridgeDefinitionProvider.getBridgeDefinitions();
            for (int i = 0; i < bridgeDefs.length; ++i) {
                log.debug((Object)("Deploying JMS bridge : " + bridgeDefs[i].getName()));
                JMSBridge bridge = new JMSBridge(bridgeDefs[i]);
                if (bridgeDefs[i].isEnabled()) {
                    bridge.start();
                } else {
                    log.debug((Object)("JMS bridge is disabled : " + bridgeDefs[i].getName()));
                }
                this.bridges.add(bridge);
                this.bridgeDeployed(bridge);
            }
        }
    }

    private void undeployBridges() {
        for (int i = 0; i < this.bridges.size(); ++i) {
            JMSBridge bridge = this.bridges.get(i);
            log.debug((Object)("Undeploying JMS bridge : " + bridge.getBridgeDefinition().getName()));
            if (bridge.isStarted()) {
                bridge.stop();
            }
            this.bridgeUndeployed(bridge);
        }
        this.bridges.clear();
    }

    @Override
    public synchronized boolean shutdown() {
        if (!this.started) {
            return false;
        }
        try {
            log.info((Object)"Server shutting down ...");
            this.undeployBridges();
            if (this.tcpListener != null) {
                this.tcpListener.stop();
                this.tcpListener = null;
            }
            if (this.adminThread != null) {
                this.adminThread.pleaseStop();
                try {
                    this.adminThread.join(30000L);
                    this.adminThread = null;
                }
                catch (InterruptedException e) {
                    log.warn((Object)"Shutdown was interrupted while waiting for the admin thread to stop");
                }
            }
            this.engine.undeploy();
            try {
                if (this.jmxAgent != null) {
                    this.jmxAgent.unregister(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName()));
                }
            }
            catch (Exception e) {
                log.error((Object)"Cannot unregister local engine from JMX agent", (Throwable)e);
            }
            if (this.jmxAgent != null) {
                this.jmxAgent.stop();
            }
            this.started = false;
            log.info((Object)"Shutdown complete.");
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Server shutdown failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    public void engineDeployed() {
        try {
            if (this.jmxAgent != null) {
                this.jmxAgent.register(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=async-managers,name=notification"), this.engine.getNotificationAsyncTaskManager());
                this.jmxAgent.register(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=async-managers,name=delivery"), this.engine.getDeliveryAsyncTaskManager());
                this.jmxAgent.register(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=async-managers,name=disk-io"), this.engine.getDiskIOAsyncTaskManager());
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot register local engine async managers from JMX agent", (Throwable)e);
        }
    }

    public void engineUndeployed() {
        try {
            if (this.jmxAgent != null) {
                this.jmxAgent.unregister(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=async-managers,name=notification"));
                this.jmxAgent.unregister(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=async-managers,name=delivery"));
                this.jmxAgent.unregister(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=async-managers,name=disk-io"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot unregister local engine async managers from JMX agent", (Throwable)e);
        }
    }

    public void queueDeployed(LocalQueue queue) {
        try {
            if (this.jmxAgent != null) {
                this.jmxAgent.register(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=queues,name=" + queue.getName()), queue);
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot register local queue on JMX agent", (Throwable)e);
        }
    }

    public void queueUndeployed(LocalQueue queue) {
        try {
            if (this.jmxAgent != null) {
                this.jmxAgent.unregister(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=queues,name=" + queue.getName()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot unregister local queue from JMX agent", (Throwable)e);
        }
    }

    public void topicDeployed(LocalTopic topic) {
        try {
            if (this.jmxAgent != null) {
                this.jmxAgent.register(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=topics,name=" + topic.getName()), topic);
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot register local topic on JMX agent", (Throwable)e);
        }
    }

    public void topicUndeployed(LocalTopic topic) {
        try {
            if (this.jmxAgent != null) {
                this.jmxAgent.unregister(new ObjectName("FFMQ:type=Engines,engine=" + this.engine.getName() + ",children=topics,name=" + topic.getName()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot unregister local topic from JMX agent", (Throwable)e);
        }
    }

    private void bridgeDeployed(JMSBridge bridge) {
        try {
            if (this.jmxAgent != null) {
                this.jmxAgent.register(new ObjectName("FFMQ:type=Bridges,bridge=" + bridge.getName()), bridge);
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot register bridge on JMX agent", (Throwable)e);
        }
    }

    private void bridgeUndeployed(JMSBridge bridge) {
        try {
            if (this.jmxAgent != null) {
                this.jmxAgent.unregister(new ObjectName("FFMQ:type=Bridges,bridge=" + bridge.getName()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot unregister bridge fromJMX agent", (Throwable)e);
        }
    }

    @Override
    public synchronized boolean isRemoteAdministrationEnabled() {
        return this.adminThread != null;
    }

    @Override
    public synchronized long getUptime() {
        return this.started ? System.currentTimeMillis() - this.startupTime : 0L;
    }

    @Override
    public synchronized void run() {
        if (!this.start()) {
            return;
        }
        try {
            this.inRunnableMode = true;
            while (!this.stopRequired) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Server was interrupted.");
        }
        this.shutdown();
    }

    public synchronized void pleaseStop() {
        this.stopRequired = true;
        this.notify();
    }

    public synchronized boolean isInRunnableMode() {
        return this.inRunnableMode;
    }
}

