/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4;

import java.io.PrintStream;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.timewalker.ffmq4.FFMQConstants;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.StringTools;

public final class FFMQAdminClient
implements Runnable {
    private Settings globalSettings;
    private Settings paramSettings;
    private Connection connection;
    private Session session;
    private PrintStream out;
    private PrintStream err;

    public FFMQAdminClient(Settings globalSettings, Settings paramSettings, PrintStream out, PrintStream err) {
        this.globalSettings = globalSettings;
        this.paramSettings = paramSettings;
        this.out = out;
        this.err = err;
    }

    private void logError(JMSException e) {
        if (e.getErrorCode() != null) {
            this.err.println("error={" + e.getErrorCode() + "} " + e.getMessage());
        } else {
            this.err.println(e.getMessage());
        }
        if (e.getLinkedException() != null) {
            this.err.println("Linked exception was : ");
            e.getLinkedException().printStackTrace(this.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String command = this.globalSettings.getStringProperty("admin.command", null);
        if (StringTools.isEmpty((String)command)) {
            this.err.println("No command specified");
            return;
        }
        try {
            this.openSession();
            this.processCommand(command);
        }
        catch (JMSException e) {
            this.logError(e);
        }
        finally {
            this.closeSession();
        }
    }

    private void openSession() throws JMSException {
        String serverHost = this.globalSettings.getStringProperty("adminClient.remoteServer.tcp.host", "localhost");
        int serverPort = this.globalSettings.getIntProperty("adminClient.remoteServer.tcp.port", 10002);
        String userName = this.globalSettings.getStringProperty("adminClient.userName", null);
        String userPassword = this.globalSettings.getStringProperty("adminClient.password", null);
        this.out.println("Opening connection to server " + serverHost + ":" + serverPort + " for user " + userName);
        this.connection = this.getConnectionFactory(serverHost, serverPort).createConnection(userName, userPassword);
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
    }

    private void closeSession() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                this.logError(e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logError(e);
            }
        }
    }

    private Context getJNDIContext(String serverHost, int serverPort) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", FFMQConstants.JNDI_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", "tcp://" + serverHost + ":" + serverPort);
        return new InitialContext(env);
    }

    private ConnectionFactory getConnectionFactory(String serverHost, int serverPort) throws JMSException {
        try {
            Context context = this.getJNDIContext(serverHost, serverPort);
            return (ConnectionFactory)context.lookup("factory/ConnectionFactory");
        }
        catch (NamingException e) {
            throw new FFMQException("Cannot lookup connection factory in JNDI context", "JNDI_ERROR", (Throwable)e);
        }
    }

    private void processCommand(String command) throws JMSException {
        if (command.equals("createQueue")) {
            this.processCreateQueue();
        } else if (command.equals("createTopic")) {
            this.processCreateTopic();
        } else if (command.equals("deleteQueue")) {
            this.processDeleteQueue();
        } else if (command.equals("deleteTopic")) {
            this.processDeleteTopic();
        } else if (command.equals("purgeQueue")) {
            this.processPurgeQueue();
        } else if (command.equals("shutdown")) {
            this.processShutdown();
        } else {
            throw new FFMQException("Unknown command : " + command, "INVALID_ADMIN_COMMAND");
        }
    }

    private void remoteExec(Message msg, boolean expectReply) throws JMSException {
        Queue requestQueue = this.session.createQueue("_FFMQ_ADM_REQUEST");
        MessageProducer producer = this.session.createProducer((Destination)requestQueue);
        producer.send(msg, 1, 4, 0L);
        String correlID = msg.getJMSMessageID();
        producer.close();
        if (expectReply) {
            Queue replyQueue = this.session.createQueue("_FFMQ_ADM_REPLY");
            MessageConsumer consumer = this.session.createConsumer((Destination)replyQueue, "JMSCorrelationID='" + correlID + "'");
            int requestTimeout = this.globalSettings.getIntProperty("adminClient.request.timeout", 30);
            Message responseMsg = consumer.receive((long)requestTimeout * 1000L);
            consumer.close();
            if (responseMsg == null) {
                throw new FFMQException("Timeout waiting for server response after " + requestTimeout + " second(s)", "NETWORK_ERROR");
            }
            String errorMsg = responseMsg.getStringProperty("FFMQ_ADM_errorMessage");
            if (StringTools.isNotEmpty((String)errorMsg)) {
                throw new FFMQException("Command failed : " + errorMsg, "NETWORK_ERROR");
            }
            this.out.println("Command sucessfully completed.");
        } else {
            this.out.println("Command sucessfully sent.");
        }
    }

    private Message createCommandMessage(String commandName) throws JMSException {
        Message msg = this.session.createMessage();
        msg.setStringProperty("FFMQ_ADM_adminCommand", commandName);
        for (String paramName : this.paramSettings.keySet()) {
            String paramValue = this.paramSettings.getStringProperty(paramName);
            msg.setStringProperty(paramName, paramValue);
        }
        return msg;
    }

    private void processCreateQueue() throws JMSException {
        String destinationName = this.paramSettings.getStringProperty("name", null);
        if (StringTools.isEmpty((String)destinationName)) {
            throw new FFMQException("Destination name not specified", "INVALID_DESTINATION_NAME");
        }
        this.out.println("Creating queue " + destinationName);
        Message msg = this.createCommandMessage("createQueue");
        this.remoteExec(msg, true);
    }

    private void processCreateTopic() throws JMSException {
        String destinationName = this.paramSettings.getStringProperty("name", null);
        if (StringTools.isEmpty((String)destinationName)) {
            throw new FFMQException("Destination name not specified", "INVALID_DESTINATION_NAME");
        }
        this.out.println("Creating topic " + destinationName);
        Message msg = this.createCommandMessage("createTopic");
        this.remoteExec(msg, true);
    }

    private void processDeleteQueue() throws JMSException {
        String destinationName = this.paramSettings.getStringProperty("name", null);
        if (StringTools.isEmpty((String)destinationName)) {
            throw new FFMQException("Destination name not specified", "INVALID_DESTINATION_NAME");
        }
        this.out.println("Deleting queue " + destinationName);
        Message msg = this.createCommandMessage("deleteQueue");
        this.remoteExec(msg, true);
    }

    private void processDeleteTopic() throws JMSException {
        String destinationName = this.paramSettings.getStringProperty("name", null);
        if (StringTools.isEmpty((String)destinationName)) {
            throw new FFMQException("Destination name not specified", "INVALID_DESTINATION_NAME");
        }
        this.out.println("Deleting topic " + destinationName);
        Message msg = this.createCommandMessage("deleteTopic");
        this.remoteExec(msg, true);
    }

    private void processPurgeQueue() throws JMSException {
        String destinationName = this.paramSettings.getStringProperty("name", null);
        if (StringTools.isEmpty((String)destinationName)) {
            throw new FFMQException("Destination name not specified", "INVALID_DESTINATION_NAME");
        }
        this.out.println("Purging queue " + destinationName);
        Message msg = this.createCommandMessage("purgeQueue");
        this.remoteExec(msg, true);
    }

    private void processShutdown() throws JMSException {
        this.out.println("Asking the server to shutdown");
        Message msg = this.createCommandMessage("shutdown");
        this.remoteExec(msg, false);
    }
}

