/*
 * Decompiled with CFR 0.152.
 */
package net.timeboxing.settings.impl;

import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.timeboxing.settings.SettingsException;
import net.timeboxing.settings.impl.AbstractFileSettings;

public final class PropertiesSettings
extends AbstractFileSettings {
    public PropertiesSettings(String fileName) {
        InputStream inputStream = null;
        if (fileName.startsWith("classpath:")) {
            String actualFilename = fileName.substring("classpath:".length());
            inputStream = this.getClass().getResourceAsStream(actualFilename);
            if (inputStream == null) {
                throw new SettingsException(String.format("Classpath resource '%s' not found", actualFilename));
            }
        } else {
            try {
                inputStream = new FileInputStream(fileName);
            }
            catch (FileNotFoundException e) {
                throw new SettingsException(String.format("File not found '%s'", fileName), e);
            }
        }
        Properties properties = new Properties();
        try (InputStream input = inputStream;){
            properties.load(input);
            this.load((Map<String, String>)Maps.fromProperties((Properties)properties));
        }
        catch (IOException e) {
            throw new SettingsException("Failed to load properties file", e);
        }
    }
}

