/*
 * Decompiled with CFR 0.152.
 */
package net.timeboxing.settings.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.timeboxing.settings.Settings;

public abstract class AbstractSettings
implements Settings {
    protected final Map<String, String> values = new HashMap<String, String>();

    protected void load(Map<String, String> values) {
        this.values.clear();
        this.values.putAll(values);
    }

    @Override
    public Optional<String> getString(String name) {
        String value = this.values.getOrDefault(name, null);
        if (null == value) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @Override
    public Optional<Integer> getInteger(String name) {
        String value = this.values.getOrDefault(name, null);
        if (null == value) {
            return Optional.empty();
        }
        return Optional.of(Integer.valueOf(value));
    }

    @Override
    public Optional<String> getStringOrDefault(String name, String defaultValue) {
        String value = this.values.getOrDefault(name, defaultValue);
        return Optional.of(value);
    }

    @Override
    public Optional<Integer> getIntegerOrDefault(String name, Integer defaultValue) {
        String value = this.values.getOrDefault(name, null);
        if (null == value) {
            return Optional.of(defaultValue);
        }
        return Optional.of(Integer.valueOf(value));
    }
}

