/*
 * Decompiled with CFR 0.152.
 */
package net.timeboxing.database;

import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbiProvider
implements Provider<Jdbi> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbiProvider.class);
    private final Provider<DataSource> dataSourceProvider;

    public JdbiProvider(Provider<DataSource> dataSourceProvider) {
        this.dataSourceProvider = dataSourceProvider;
    }

    public Jdbi get() {
        LOG.debug("Getting JDBI instance");
        return Jdbi.create((ConnectionFactory)new DataSourceProviderConnectionFactory(this.dataSourceProvider));
    }

    private class DataSourceProviderConnectionFactory
    implements ConnectionFactory {
        private final Provider<DataSource> dataSourceProvider;

        public DataSourceProviderConnectionFactory(Provider<DataSource> dataSourceProvider) {
            this.dataSourceProvider = dataSourceProvider;
        }

        public Connection openConnection() throws SQLException {
            return ((DataSource)this.dataSourceProvider.get()).getConnection();
        }
    }
}

