/*
 * Decompiled with CFR 0.152.
 */
package net.timeboxing.database;

import java.lang.annotation.Annotation;
import javax.inject.Provider;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.timeboxing.database.DataSourceNotFoundException;

public class JNDIDataSourceProvider
implements Provider<DataSource> {
    private final Class<? extends Annotation> dataSourceAnnotation;
    private final String jndiName;

    public JNDIDataSourceProvider(Class<? extends Annotation> dataSourceAnnotation, String jndiName) {
        this.dataSourceAnnotation = dataSourceAnnotation;
        this.jndiName = jndiName;
    }

    public DataSource get() {
        try {
            return (DataSource)InitialContext.doLookup(this.jndiName);
        }
        catch (NamingException e) {
            throw new DataSourceNotFoundException(e);
        }
    }
}

