/*
 * Decompiled with CFR 0.152.
 */
package net.timeboxing.database;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import javax.sql.DataSource;
import net.timeboxing.database.JNDIDataSourceProvider;
import net.timeboxing.database.JdbiProvider;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceModule.class);
    private final Class<? extends Annotation> dataSourceAnnotation;
    private final String jndiName;

    public DataSourceModule(Class<? extends Annotation> dataSource, String jndiName) {
        this.dataSourceAnnotation = dataSource;
        this.jndiName = jndiName;
    }

    protected void configure() {
        super.configure();
        LOG.debug("Creating binding for {} with JNDI name '{}'", (Object)this.dataSourceAnnotation.getSimpleName(), (Object)this.jndiName);
        JNDIDataSourceProvider dataSourceProvider = new JNDIDataSourceProvider(this.dataSourceAnnotation, this.jndiName);
        this.bind(DataSource.class).annotatedWith(this.dataSourceAnnotation).toProvider((Provider)dataSourceProvider);
        this.bind(Jdbi.class).annotatedWith(this.dataSourceAnnotation).toProvider((Provider)new JdbiProvider(dataSourceProvider)).in(Scopes.SINGLETON);
    }
}

