/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import net.time4j.tz.FallbackTimezone;
import net.time4j.tz.GapResolver;
import net.time4j.tz.HistorizedTimezone;
import net.time4j.tz.OverlapResolver;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionResolver;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

final class SPX
implements Externalizable {
    static final int FALLBACK_TIMEZONE_TYPE = 12;
    static final int TRANSITION_RESOLVER_TYPE = 13;
    static final int HISTORIZED_TIMEZONE_TYPE = 14;
    static final int ZONAL_OFFSET_TYPE = 15;
    private static final long serialVersionUID = -1000776907354520172L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 12: {
                this.writeFallback(objectOutput);
                break;
            }
            case 13: {
                this.writeStrategy(objectOutput);
                break;
            }
            case 14: {
                this.writeZone(objectOutput);
                break;
            }
            case 15: {
                this.writeOffset(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch ((by & 0xFF) >> 4) {
            case 12: {
                this.obj = this.readFallback(objectInput, by);
                break;
            }
            case 13: {
                this.obj = this.readStrategy(objectInput, by);
                break;
            }
            case 14: {
                this.obj = this.readZone(objectInput, by);
                break;
            }
            case 15: {
                this.obj = this.readOffset(objectInput, by);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeFallback(ObjectOutput objectOutput) throws IOException {
        FallbackTimezone fallbackTimezone = (FallbackTimezone)this.obj;
        int n = 192;
        objectOutput.writeByte(n);
        objectOutput.writeObject(fallbackTimezone.getID());
        objectOutput.writeObject(fallbackTimezone.getFallback());
    }

    private Object readFallback(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        TZID tZID = (TZID)objectInput.readObject();
        Timezone timezone = (Timezone)objectInput.readObject();
        return new FallbackTimezone(tZID, timezone);
    }

    private void writeStrategy(ObjectOutput objectOutput) throws IOException {
        TransitionResolver transitionResolver = (TransitionResolver)this.obj;
        int n = 208;
        objectOutput.writeByte(n |= transitionResolver.getKey());
    }

    private Object readStrategy(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        int n = by & 0xF;
        GapResolver gapResolver = GapResolver.values()[n / 2];
        OverlapResolver overlapResolver = OverlapResolver.values()[n % 2];
        return TransitionResolver.of(gapResolver, overlapResolver);
    }

    private void writeZone(ObjectOutput objectOutput) throws IOException {
        boolean bl;
        HistorizedTimezone historizedTimezone = (HistorizedTimezone)this.obj;
        int n = 224;
        boolean bl2 = bl = historizedTimezone.getStrategy() != Timezone.DEFAULT_CONFLICT_STRATEGY;
        if (bl) {
            n |= 1;
        }
        objectOutput.writeByte(n);
        objectOutput.writeObject(historizedTimezone.getID());
        objectOutput.writeObject(historizedTimezone.getHistory());
        if (bl) {
            objectOutput.writeObject(historizedTimezone.getStrategy());
        }
    }

    private Object readZone(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        TZID tZID = (TZID)objectInput.readObject();
        TransitionHistory transitionHistory = (TransitionHistory)objectInput.readObject();
        TransitionStrategy transitionStrategy = Timezone.DEFAULT_CONFLICT_STRATEGY;
        if ((by & 0xF) == 1) {
            transitionStrategy = (TransitionStrategy)objectInput.readObject();
        }
        return new HistorizedTimezone(tZID, transitionHistory, transitionStrategy);
    }

    private void writeOffset(ObjectOutput objectOutput) throws IOException {
        ZonalOffset zonalOffset = (ZonalOffset)this.obj;
        boolean bl = zonalOffset.getFractionalAmount() != 0;
        int n = 240;
        if (bl) {
            n |= 1;
        }
        objectOutput.writeByte(n);
        objectOutput.writeInt(zonalOffset.getIntegralAmount());
        if (bl) {
            objectOutput.writeInt(zonalOffset.getFractionalAmount());
        }
    }

    private Object readOffset(ObjectInput objectInput, byte by) throws IOException {
        int n = objectInput.readInt();
        int n2 = 0;
        if ((by & 0xF) == 1) {
            n2 = objectInput.readInt();
        }
        return ZonalOffset.ofTotalSeconds(n, n2);
    }
}

