/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.hamcrest;

import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLIsSimilarMatcher
extends TypeSafeMatcher<String> {
    private String xmlDocument;
    private String errorMessage = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLIsSimilarMatcher.class);

    public XMLIsSimilarMatcher(String xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public boolean matchesSafely(String expectedXML) {
        boolean xmlIsSimilar = true;
        Diff difference = null;
        try {
            XMLUnit.setIgnoreAttributeOrder((boolean)true);
            XMLUnit.setIgnoreComments((boolean)true);
            XMLUnit.setIgnoreWhitespace((boolean)true);
            difference = new Diff(this.xmlDocument, expectedXML);
            xmlIsSimilar = difference.similar();
        }
        catch (Exception e) {
            xmlIsSimilar = false;
            LOGGER.info(e.getMessage());
        }
        if (!xmlIsSimilar) {
            this.recordErrorMessage(difference);
        }
        return xmlIsSimilar;
    }

    private void recordErrorMessage(Diff difference) {
        StringBuffer buffer = new StringBuffer();
        if (difference != null) {
            buffer = difference.appendMessage(buffer);
        }
        this.errorMessage = buffer.toString();
    }

    public void describeTo(Description description) {
        description.appendText("an XML document equivalent to ").appendText(this.xmlDocument);
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            description.appendText("[").appendText(this.errorMessage).appendText("]");
        }
    }
}

