/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.thucydides.core.reports.ThucydidesReportData;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import net.thucydides.maven.plugins.MavenProjectHelper;
import net.thucydides.maven.plugins.ThucydidesHTMLReportGenerator;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

public class ThucydidesReportMojo
extends AbstractMavenReport {
    protected MavenProject project;
    private File targetDirectory;
    protected String outputDirectory;
    protected File sourceDirectory;
    private Renderer siteRenderer;
    private HtmlAggregateStoryReporter reporter;
    private ThucydidesHTMLReportGenerator htmlReportGenerator;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ThucydidesHTMLReportGenerator getHtmlReportGenerator() {
        if (this.htmlReportGenerator == null) {
            this.htmlReportGenerator = new ThucydidesHTMLReportGenerator();
        }
        return this.htmlReportGenerator;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getOutputName() {
        return "thucydides";
    }

    public String getName(Locale locale) {
        return "Thucydides Web tests";
    }

    public String getDescription(Locale locale) {
        return "Test reports generated by Thucydides.";
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)"Generating Thucydides Reports");
        ThucydidesReportData reportData = this.generateHtmlStoryReports();
        this.getHtmlReportGenerator().generateReport(reportData, this.getSink());
    }

    protected HtmlAggregateStoryReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = new HtmlAggregateStoryReporter(MavenProjectHelper.getProjectIdentifier(this.project));
        }
        return this.reporter;
    }

    private ThucydidesReportData generateHtmlStoryReports() throws MavenReportException {
        File reportDirectory = new File(this.outputDirectory, "thucydides");
        this.getLog().info((CharSequence)("Generating reports from " + this.sourceDirectory));
        this.getLog().info((CharSequence)("Generating reports to " + reportDirectory));
        this.getReporter().setOutputDirectory(reportDirectory);
        try {
            return this.getReporter().generateReportsForStoriesFrom(this.sourceDirectory);
        }
        catch (IOException e) {
            throw new MavenReportException("Error generating aggregate thucydides reports", (Exception)e);
        }
    }
}

