/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.maven.plugins;

import java.util.List;
import net.thucydides.core.model.FeatureResults;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.reports.ThucydidesReportData;
import org.apache.maven.doxia.sink.Sink;

public class ThucydidesHTMLReportGenerator {
    public void generateReport(ThucydidesReportData reportData, Sink sink) {
        sink.head();
        this.generateTitle(sink);
        sink.head_();
        sink.body();
        this.generateOverviewSection(sink);
        this.generateFeatureTable(reportData, sink);
        this.generateStoriesTable(reportData, sink);
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void generateTitle(Sink sink) {
        sink.title();
        sink.text("Thucydides Report");
        sink.title_();
    }

    private void generateOverviewSection(Sink sink) {
        sink.section1();
        this.sectionTitle(sink, "Overview");
        sink.sectionTitle2();
        sink.link("thucydides/index.html");
        sink.rawText("Dashboard");
        sink.link_();
        sink.sectionTitle2_();
        sink.sectionTitle2();
        sink.link("thucydides/features.html");
        sink.rawText("Features");
        sink.link_();
        sink.sectionTitle2_();
        sink.sectionTitle2();
        sink.link("thucydides/stories.html");
        sink.rawText("Stories");
        sink.link_();
        sink.sectionTitle2_();
        sink.section1_();
    }

    private void generateFeatureTable(ThucydidesReportData reportData, Sink sink) {
        sink.section1();
        this.sectionTitle(sink, "Features");
        sink.table();
        sink.tableRow();
        this.tableHeader(sink, "Feature");
        this.tableHeader(sink, "Total stories");
        this.tableHeader(sink, "Passing stories");
        this.tableHeader(sink, "Pending stories");
        this.tableHeader(sink, "Failing stories");
        this.tableHeader(sink, "Coverage");
        sink.tableRow_();
        List featureResults = reportData.getFeatureResults();
        for (FeatureResults featureResult : featureResults) {
            sink.tableRow();
            this.tableCellWithLink(sink, featureResult.getFeature().getName(), "thucydides/" + featureResult.getStoryReportName());
            this.tableCell(sink, featureResult.getTotalStories().toString());
            this.tableCell(sink, featureResult.getPassingTests().toString());
            this.tableCell(sink, featureResult.getPendingTests().toString());
            this.tableCell(sink, featureResult.getFailingTests().toString());
            String percentageCoverage = String.format("%.1f%%", featureResult.getCoverage() * 100.0);
            this.tableCell(sink, percentageCoverage);
            sink.tableRow_();
        }
        sink.table_();
        sink.section1_();
    }

    private void generateStoriesTable(ThucydidesReportData reportData, Sink sink) {
        sink.section1();
        this.sectionTitle(sink, "Stories");
        sink.table();
        sink.tableRow();
        this.tableHeader(sink, "Story");
        this.tableHeader(sink, "Total tests");
        this.tableHeader(sink, "Passing tests");
        this.tableHeader(sink, "Pending tests");
        this.tableHeader(sink, "Failing tests");
        this.tableHeader(sink, "Step Coverage");
        sink.tableRow_();
        List storyResults = reportData.getStoryResults();
        for (StoryTestResults storyResult : storyResults) {
            sink.tableRow();
            this.tableCellWithLink(sink, storyResult.getTitle(), "thucydides/" + storyResult.getReportName(ReportNamer.ReportType.HTML));
            this.tableCell(sink, Integer.toString(storyResult.getTotal()));
            this.tableCell(sink, Integer.toString(storyResult.getSuccessCount()));
            this.tableCell(sink, Integer.toString(storyResult.getPendingCount()));
            this.tableCell(sink, Integer.toString(storyResult.getFailureCount()));
            String percentageCoverage = String.format("%.1f%%", storyResult.getCoverage() * 100.0);
            this.tableCell(sink, percentageCoverage);
            sink.tableRow_();
        }
        sink.table_();
        sink.section1_();
    }

    private void tableHeader(Sink sink, String heading) {
        sink.tableHeaderCell();
        sink.rawText(heading);
        sink.tableHeaderCell_();
    }

    private void tableCell(Sink sink, String heading) {
        sink.tableCell();
        sink.rawText(heading);
        sink.tableCell_();
    }

    private void tableCellWithLink(Sink sink, String heading, String link) {
        sink.tableCell();
        sink.link(link);
        sink.rawText(heading);
        sink.link_();
        sink.tableCell_();
    }

    private void sectionTitle(Sink sink, String title) {
        sink.sectionTitle1();
        sink.rawText(title);
        sink.sectionTitle1_();
    }
}

