/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.maven.plugins;

import java.io.File;
import java.io.IOException;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import net.thucydides.maven.plugins.MavenProjectHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ThucydidesAggregatorMojo
extends AbstractMojo {
    protected MavenProject project;
    private File outputDirectory;
    private File sourceDirectory;
    private String issueTrackerUrl;
    private String jiraUrl;
    private String jiraProject;
    private HtmlAggregateStoryReporter reporter;

    protected void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    protected void setProject(MavenProject project) {
        this.project = project;
    }

    protected void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    protected void setReporter(HtmlAggregateStoryReporter reporter) {
        this.reporter = reporter;
    }

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        try {
            this.generateHtmlStoryReports();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating aggregate thucydides reports", (Exception)e);
        }
    }

    protected HtmlAggregateStoryReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = new HtmlAggregateStoryReporter(MavenProjectHelper.getProjectIdentifier(this.project));
        }
        return this.reporter;
    }

    private void generateHtmlStoryReports() throws IOException {
        this.getReporter().setOutputDirectory(this.outputDirectory);
        this.getReporter().setIssueTrackerUrl(this.issueTrackerUrl);
        this.getReporter().setJiraUrl(this.jiraUrl);
        this.getReporter().setJiraProject(this.jiraProject);
        this.getReporter().generateReportsForStoriesFrom(this.sourceDirectory);
    }
}

