/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.JsonQueryFunction;
import net.thisptr.jackson.jq.path.Path;

public class FunctionDefinition
implements Expression {
    private Expression body;
    private String fname;
    private List<String> args;

    public FunctionDefinition(String fname, List<String> args, Expression body) {
        this.fname = fname;
        this.args = args;
        this.body = body;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        scope.addFunction(this.fname, this.args.size(), new JsonQueryFunction(this.fname, this.args, this.body, scope));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("def ");
        builder.append(this.fname);
        if (!this.args.isEmpty()) {
            builder.append("(");
            String sep = "";
            for (String arg : this.args) {
                builder.append(sep);
                builder.append(arg);
                sep = "; ";
            }
            builder.append(")");
        }
        builder.append(": ");
        builder.append(this.body);
        return builder.toString();
    }
}

