/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.service.AutoService;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.internal.JsonPredicateFunction;

@BuiltinFunction(value={"isnormal/0"})
@AutoService(value={Function.class})
public class IsNormalFunction
extends JsonPredicateFunction {
    public IsNormalFunction() {
        super(IsNormalFunction::test);
    }

    private static boolean test(JsonNode value) {
        if (!value.isNumber()) {
            return false;
        }
        double v = value.asDouble();
        return !Double.isInfinite(v) && (v <= -2.2250738585072014E-308 || Double.MIN_NORMAL <= v);
    }
}

