/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class TryCatch
extends JsonQuery {
    private JsonQuery tryExpr;
    private JsonQuery catchExpr;

    public TryCatch(JsonQuery tryExpr, JsonQuery catchExpr) {
        this.tryExpr = tryExpr;
        this.catchExpr = catchExpr;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        try {
            return this.tryExpr.apply(scope, in);
        }
        catch (JsonQueryException e) {
            return this.catchExpr.apply(scope, (JsonNode)new TextNode(e.getMessage()));
        }
    }

    public String toString() {
        return String.format("(try (%s) catch (%s))", this.tryExpr, this.catchExpr);
    }
}

