/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryBreakException;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class ReduceExpression
extends JsonQuery {
    private JsonQuery iterExpr;
    private JsonQuery reduceExpr;
    private JsonQuery initExpr;
    private String boundVarName;

    public ReduceExpression(String boundVarName, JsonQuery initExpr, JsonQuery reduceExpr, JsonQuery iterExpr) {
        this.boundVarName = boundVarName;
        this.initExpr = initExpr;
        this.reduceExpr = reduceExpr;
        this.iterExpr = iterExpr;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode accumulator : this.initExpr.apply(scope, in)) {
            Scope childScope = new Scope(scope);
            try {
                for (JsonNode item : this.iterExpr.apply(scope, in)) {
                    childScope.setValue(this.boundVarName, item);
                    Iterator<JsonNode> iterator = this.reduceExpr.apply(childScope, accumulator).iterator();
                    while (iterator.hasNext()) {
                        JsonNode newvalue;
                        accumulator = newvalue = iterator.next();
                    }
                }
            }
            catch (JsonQueryBreakException jsonQueryBreakException) {
                // empty catch block
            }
            out.add(accumulator);
        }
        return out;
    }

    public String toString() {
        return String.format("(reduce %s as $%s (%s; %s))", this.iterExpr, this.boundVarName, this.initExpr, this.reduceExpr);
    }
}

