/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Pair;

public class PipedQuery
extends JsonQuery {
    private List<Pair<JsonQuery, String>> qs;

    public PipedQuery(List<Pair<JsonQuery, String>> qs) {
        this.qs = qs;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        PipedQuery.applyRecursive(scope, in, out, this.qs);
        return out;
    }

    private static void applyRecursive(Scope scope, JsonNode in, List<JsonNode> out, List<Pair<JsonQuery, String>> qs) throws JsonQueryException {
        if (qs.isEmpty()) {
            out.add(in);
            return;
        }
        Pair<JsonQuery, String> head = qs.get(0);
        JsonQuery q = (JsonQuery)head._1;
        String var = (String)head._2;
        Scope scope2 = var != null ? new Scope(scope) : scope;
        for (JsonNode o : q.apply(scope, in)) {
            if (var != null) {
                scope2.setValue(var, o);
                PipedQuery.applyRecursive(scope2, in, out, qs.subList(1, qs.size()));
                continue;
            }
            PipedQuery.applyRecursive(scope2, o, out, qs.subList(1, qs.size()));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("(");
        String sep = "";
        for (Pair<JsonQuery, String> q : this.qs) {
            builder.append(sep);
            builder.append(((JsonQuery)q._1).toString());
            if (q._2 != null) {
                builder.append(" as $");
                builder.append((String)q._2);
            }
            sep = " | ";
        }
        builder.append(")");
        return builder.toString();
    }
}

