/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryBreakException;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class ForeachExpression
extends JsonQuery {
    private JsonQuery iterExpr;
    private JsonQuery updateExpr;
    private JsonQuery initExpr;
    private String var;
    private JsonQuery extractExpr;

    public ForeachExpression(String var, JsonQuery initExpr, JsonQuery updateExpr, JsonQuery extractExpr, JsonQuery iterExpr) {
        this.var = var;
        this.initExpr = initExpr;
        this.updateExpr = updateExpr;
        this.extractExpr = extractExpr;
        this.iterExpr = iterExpr;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode accumulator : this.initExpr.apply(scope, in)) {
            Scope childScope = new Scope(scope);
            for (JsonNode item : this.iterExpr.apply(scope, in)) {
                childScope.setValue(this.var, item);
                try {
                    for (JsonNode newaccumulator : this.updateExpr.apply(childScope, accumulator)) {
                        if (this.extractExpr != null) {
                            for (JsonNode extract : this.extractExpr.apply(childScope, newaccumulator)) {
                                out.add(extract);
                            }
                        } else {
                            out.add(newaccumulator);
                        }
                        accumulator = newaccumulator;
                    }
                }
                catch (JsonQueryBreakException jsonQueryBreakException) {
                }
            }
        }
        return out;
    }

    public String toString() {
        if (this.extractExpr == null) {
            return String.format("(foreach %s as $%s (%s; %s))", this.iterExpr, this.var, this.initExpr, this.updateExpr);
        }
        return String.format("(foreach %s as $%s (%s; %s; %s))", this.iterExpr, this.var, this.initExpr, this.updateExpr, this.extractExpr);
    }
}

