/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.operators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.regex.Pattern;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.operators.BinaryOperator;

public class DivideOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isNumber() && rhs.isNumber()) {
            double r = lhs.asDouble() / rhs.asDouble();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isTextual() && rhs.isTextual()) {
            ArrayNode result = mapper.createArrayNode();
            for (String token : lhs.asText().split(Pattern.quote(rhs.asText()))) {
                result.add((JsonNode)new TextNode(token));
            }
            return result;
        }
        throw new JsonQueryTypeException(lhs, rhs, "cannot be divided");
    }

    @Override
    public String image() {
        return "/";
    }
}

