/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.misc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.Arrays;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.IllegalJsonArgumentException;
import net.thisptr.jackson.jq.exception.IllegalJsonInputException;

public class Preconditions {
    public static void checkArgumentCount(String fname, List<JsonQuery> args, int ... nums) throws IllegalJsonArgumentException {
        int nargs = args.size();
        for (int num : nums) {
            if (nargs != num) continue;
            return;
        }
        throw new IllegalJsonArgumentException(String.format("%s takes %s arguments; got %s", fname, Arrays.toString(nums), nargs));
    }

    public static void checkInputType(String fname, JsonNode in, JsonNodeType ... types) throws IllegalJsonInputException {
        JsonNodeType t = in.getNodeType();
        for (JsonNodeType type : types) {
            if (t != type) continue;
            return;
        }
        throw new IllegalJsonInputException(String.format("%s is not applicable to %s; expected one of %s", fname, in.getNodeType(), Arrays.toString(types)));
    }

    private static void checkInputElementType(String fname, JsonNode in, JsonNodeType ... types) throws IllegalJsonInputException {
        JsonNodeType t = in.getNodeType();
        for (JsonNodeType type : types) {
            if (t != type) continue;
            return;
        }
        throw new IllegalJsonInputException(String.format("%s is not applicable to input which contains %s; expected one of %s", fname, in.getNodeType(), Arrays.toString(types)));
    }

    public static void checkInputArrayType(String fname, JsonNode in, JsonNodeType ... types) throws IllegalJsonInputException {
        Preconditions.checkInputType(fname, in, JsonNodeType.ARRAY);
        for (JsonNode i : in) {
            Preconditions.checkInputElementType(fname, i, types);
        }
    }
}

