/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.internal.misc.Strings;

@BuiltinFunction(value={"split/1"})
public class SplitFunction
implements Function {
    private String fname;

    protected SplitFunction(String fname) {
        this.fname = fname;
    }

    public SplitFunction() {
        this("split");
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType(this.fname, in, JsonNodeType.STRING);
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode sep : args.get(0).apply(scope, in)) {
            if (!sep.isTextual()) {
                throw new JsonQueryException("1st argument of " + this.fname + "() must evaluate to string, not " + sep.getNodeType());
            }
            ArrayNode row = scope.getObjectMapper().createArrayNode();
            for (String seg : this.split(in.asText(), sep.asText())) {
                row.add((JsonNode)new TextNode(seg));
            }
            out.add((JsonNode)row);
        }
        return out;
    }

    protected String[] split(String in, String sep) {
        ArrayList<String> result;
        if (sep.isEmpty()) {
            int codepoint;
            result = new ArrayList<String>();
            int length = in.length();
            for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
                codepoint = in.codePointAt(offset);
                result.add(new String(Character.toChars(codepoint)));
            }
        } else {
            return Strings.splitToArray(in, sep);
        }
        return result.toArray(new String[result.size()]);
    }
}

