/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"scan/1"})
public class ScanFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("scan", in, JsonNodeType.STRING);
        String inputText = in.asText();
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode regex : args.get(0).apply(scope, in)) {
            if (!regex.isTextual()) {
                throw new JsonQueryException("1st argument to scan() must be a string");
            }
            Pattern p = Pattern.compile(regex.asText());
            Matcher m = p.matcher(inputText);
            while (m.find()) {
                out.add((JsonNode)new TextNode(m.group()));
            }
        }
        return out;
    }
}

