/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"match/2"})
public class MatchFunction
implements Function {
    private static Method namedGroupsMethod = null;

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("match", in, JsonNodeType.STRING);
        ArrayList<MatchObject> out = new ArrayList<MatchObject>();
        List<JsonNode> regexTuple = args.get(0).apply(scope, in);
        List<JsonNode> modifiersTuple = args.get(1).apply(scope, in);
        for (JsonNode regex : regexTuple) {
            for (JsonNode modifiers : modifiersTuple) {
                out.addAll(MatchFunction.match(in, regex, modifiers));
            }
        }
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        for (MatchObject m : out) {
            result.add(scope.getObjectMapper().valueToTree((Object)m));
        }
        return result;
    }

    public static List<MatchObject> match(JsonNode haystack, JsonNode regex, JsonNode modifiers) throws JsonQueryException {
        if (!regex.isTextual()) {
            throw new JsonQueryException("regex argument to match() must be a string, got " + regex.getNodeType());
        }
        if (!modifiers.isTextual() && !modifiers.isNull()) {
            throw new JsonQueryException("modifiers argument to match() must be a string, got " + modifiers.getNodeType());
        }
        return MatchFunction.match(haystack.asText(), regex.asText(), modifiers.isNull() ? "" : modifiers.asText());
    }

    public static Map<Integer, String> namedGroups(Pattern regex) {
        if (namedGroupsMethod == null) {
            return null;
        }
        try {
            Map tmp = (Map)namedGroupsMethod.invoke((Object)regex, new Object[0]);
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            for (Map.Entry e : tmp.entrySet()) {
                result.put((Integer)e.getValue(), (String)e.getKey());
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public static List<MatchObject> match(String haystack, String regex, String modifiers) {
        boolean flagGlobal = modifiers.contains("g");
        boolean flagIgnoreEmpty = modifiers.contains("n");
        ArrayList<MatchObject> result = new ArrayList<MatchObject>();
        Pattern pattern = Pattern.compile(regex, MatchFunction.makeFlags(modifiers));
        Map<Integer, String> namedGroups = MatchFunction.namedGroups(pattern);
        Matcher m = pattern.matcher(haystack);
        while (m.find()) {
            MatchObject obj = new MatchObject();
            obj.offset = m.start();
            obj.length = m.end() - obj.offset;
            obj.string = m.group();
            if (flagIgnoreEmpty && obj.length == 0) continue;
            for (int i = 1; i <= m.groupCount(); ++i) {
                CaptureObject capture = new CaptureObject();
                capture.offset = m.start(i);
                capture.length = m.end(i) - capture.offset;
                capture.string = m.group(i);
                if (namedGroups != null) {
                    capture.name = namedGroups.get(i);
                }
                obj.captures.add(capture);
            }
            result.add(obj);
            if (flagGlobal) continue;
            break;
        }
        return result;
    }

    private static int makeFlags(String modifiers) {
        int flags = 0;
        if (modifiers.contains("i")) {
            flags |= 0x42;
        }
        if (modifiers.contains("m") || modifiers.contains("p")) {
            flags |= 8;
        }
        if (modifiers.contains("s") || modifiers.contains("p")) {
            flags |= 0x20;
        }
        if (modifiers.contains("x")) {
            flags |= 4;
        }
        return flags;
    }

    static {
        try {
            namedGroupsMethod = Pattern.class.getDeclaredMethod("namedGroups", new Class[0]);
            namedGroupsMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class MatchObject {
        @JsonProperty(value="offset")
        public int offset;
        @JsonProperty(value="length")
        public int length;
        @JsonProperty(value="string")
        public String string;
        @JsonProperty(value="captures")
        public List<CaptureObject> captures = new ArrayList<CaptureObject>();

        MatchObject() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CaptureObject {
        @JsonProperty(value="offset")
        public int offset;
        @JsonProperty(value="length")
        public int length;
        @JsonProperty(value="string")
        public String string;
        @JsonProperty(value="name")
        public String name;

        private CaptureObject() {
        }
    }
}

